/* 
 * Copyright 2004, 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf.cmd;

import org.unitarou.cmd.AbstractCommand;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;

/**
 * w肵{@link org.unitarou.sgf.GameTree}̍ŏIm[h폜܂B
 * ŃV[PX̒0ɂȂꍇ͂GameTreê̂폜܂B
 * ܂AV[PX̒Ƃ0{@link #execute()}sꍇ́A
 * {@link java.lang.IllegalStateException}o܂B
 * 
 * @author UNITAROU &lt;boss@unitarou.org&gt;
 */
public class RemoveLastNode extends AbstractCommand {
	private final GameTree target_;
	private final GameTree parent_;
	private Node node_;
	private RemoveGameTree removeGameTree_;

	/**
	 * target̍ŏIm[h폜܂B
	 * ŃV[PX̒0ɂȂꍇ͂GameTreê̂폜܂B
	 * 
	 */
	public RemoveLastNode(GameTree target) {
		super();
		if (target == null) {
			throw new NullPointerException("Argument(target) must not be null. ");  //$NON-NLS-1$

		} else if (target.getChildren().length != 0) {
			throw new IllegalArgumentException("A target must not have any children.");  //$NON-NLS-1$
		}
		target_ = target;
		parent_ = target.getParent();
		node_ = null;
		removeGameTree_ = null;
	}

	/** 
	 * w肵{@link org.unitarou.sgf.GameTree}̍ŏIm[h폜܂B
	 * ŃV[PX̒0ɂȂꍇ͂GameTreê̂폜܂B
	 * 
	 * @throws IllegalStateException V[PX̒Ƃ0̏ꍇ
	 * @see org.unitarou.sgf.cmd.Command#execute()
	 */
	@Override
	public void execute() {		
		super.execute();
		node_ = target_.getSequence().removeLast();
		if (node_ == null) {
			throw new IllegalStateException("Cannot remove the last node. "); //$NON-NLS-1$
		}
		if ( (target_.getSequence().size() == 0) && (parent_ != null) ) {
		    removeGameTree_ = new RemoveGameTree(parent_, target_);
		    removeGameTree_.execute();
		}
	}

	/* (non-Javadoc)
	 * @see org.unitarou.sgf.cmd.Command#undo()
	 */
	@Override
	public void undo() {
		super.undo();
		target_.getSequence().addLast(node_);
		if (removeGameTree_ != null) {
		    removeGameTree_.undo();
		    removeGameTree_ = null;
		}
		node_ = null;
	}
}
