/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf.cmd;

import java.util.Iterator;

import org.unitarou.cmd.AbstractCommand;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.Sequence;
import org.unitarou.util.ArgumentChecker;

/**
 * RXgN^Ŏw肵{@link org.unitarou.sgf.Node}
 * {@link org.unitarou.sgf.Sequence}폜R}hłB<br>
 * {@link org.unitarou.sgf.Sequence}̒0ɂȂꍇ
 * q{@link org.unitarou.sgf.GameTree}g̐eɓo^܂B<br>
 * 
 * {@link org.unitarou.sgf.Node}{@link org.unitarou.sgf.Sequence}ɑ݂ȂꍇA
 * [gm[hSequencePŎqGameTreeꍇ(폜Root̏ɕ򂪕Kv)
 * {@link java.lang.IllegalStateException}o܂B 
 * 
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class RemoveNode extends AbstractCommand {

	private final GameTree parent_;
	private final GameTree gameTree_;
	private final Node target_;

	/**
	 * {@link #undo()}̎̑}|CgłB
	 * 폜ꍇ<code>null</code>܂B
	 */
	private final Node insertPoint_;
	
	/**
	 * sequencẽTCY1̎{@link #gameTree_}̎q܂B
	 * ȊȌꍇnullɂȂ܂B
	 */
	private final GameTree[] children_;
	
	/**
	 * sequencẽTCY1̎{@link #parent__}̎q܂B
	 * ȊȌꍇnullɂȂ܂B
	 */
	private final GameTree[] siblings_;
	
	/**
	 * target_V[PX̖ŎqȂꍇA
	 * ̃R}hs܂B
	 * ȊÔƂnullێ܂B
	 */
	private final RemoveLastNode removeLastNode_;
	
	/**
	 * gameTree{@link Sequence}ɂtarget폜R}h쐬܂B
	 * 
	 * @throws org.unitarou.lang.NullArgumentException null̏ꍇ 
	 * @throws IllegalArgumentException 
	 *          {@link org.unitarou.sgf.Node}{@link org.unitarou.sgf.Sequence}ɑ݂Ȃꍇ
	 *          [gm[hSequencePŎqGameTreeꍇ(폜Root̏ɕ򂪕Kv)
	 */
	public RemoveNode(GameTree gameTree, Node target) {
		super();
		ArgumentChecker.throwIfNull(gameTree, target);
		
		gameTree_ = gameTree;
		parent_ = gameTree_.getParent();
		Sequence sequence = gameTree_.getSequence();
		if ( (gameTree_ instanceof RootGameTree) 
				&& (sequence.size() == 1)
				&& (2 <= gameTree_.getChildrenSize())) 
		{
			throw new IllegalArgumentException("Bad argument, can't remove root sequence."); //$NON-NLS-1$
		}
		target_ = target;
		
		boolean found = false;
		Node point = null;
		for(Iterator<Node> ip = sequence.iterator(); ip.hasNext(); ) {
			Node node = ip.next();
			if (node == target_) {
				point = ip.hasNext() ? ip.next() : null;
				found = true;
				break;
			}
		}
		insertPoint_ = point;
		
		if (!found) {
			throw new IllegalArgumentException(
					"Can't find target node(" + target_  //$NON-NLS-1$
					+ ") in the sequence (" + sequence + ')'); //$NON-NLS-1$
		}
		
		if (sequence.size() == 1) {
			children_ = gameTree.getChildren();
			siblings_ = parent_.getChildren();
		} else {
			children_ = null;
			siblings_ = null;
		}
		
		if ((gameTree_.getSequence().getLast() == target_)
				&& (gameTree_.getChildrenSize() == 0)) 
		{
			removeLastNode_ = new RemoveLastNode(gameTree_);
		} else {
			removeLastNode_ = null;
		}
	}

	/* (non-Javadoc)
	 * @see org.unitarou.cmd.AbstractCommand#execute()
	 */
	@Override
	public void execute() {
		super.execute();
		if (removeLastNode_ != null) {
			removeLastNode_.execute();
			return;
		}
		Sequence sequence = gameTree_.getSequence();
		sequence.remove(target_);
		if (sequence.size() != 0) {
			return;
		}
		
		//V[PX0ɂȂꍇ́AeGameTreeɓKvB
		parent_.removeGameTree(gameTree_);
		for (GameTree child : children_) {
			gameTree_.removeGameTree(child);
			parent_.addGameTree(child);
		}
	}

	/* (non-Javadoc)
	 * @see org.unitarou.cmd.AbstractCommand#undo()
	 */
	@Override
	public void undo() {
		super.undo();
		if (removeLastNode_ != null) {
			removeLastNode_.undo();
			return;
		}
		
		Sequence sequence = gameTree_.getSequence();
		if (insertPoint_ != null) {
			sequence.insert(target_, insertPoint_);
		} else {
			sequence.addLast(target_);
		}
		
		if (sequence.size() != 1) {
			return;
		}
		
		// V[PX0ꍇ́AeGameTreeグ
		// ̎qɂKvB
		for (GameTree sibling : siblings_) {
			parent_.removeGameTree(sibling);
		}
		for (GameTree child : children_) {
			parent_.removeGameTree(child);
		}

		for (GameTree sibling : siblings_) {
			parent_.addGameTree(sibling);
		}
		for (GameTree child : children_) {
			gameTree_.addGameTree(child);
		}
	}
}
