/* 
 * Copyright 2004, 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf.cmd;

import org.unitarou.cmd.AbstractCommand;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Property;

/**
 * @author UNITAROU &lt;boss@unitarou.org&gt;
 */
public class RemoveProperty extends AbstractCommand {
	private final Node node_;
	private final Property[] properties_;
	private final String id_;
	private Property removed_;

	/**
	 * 
	 */
	public RemoveProperty(Node node, String id) {
		super();
		if (node == null) {
			throw new NullPointerException("Arguments must not be null. "  //$NON-NLS-1$
										+	"node_ = " + node + " id = " + id);  //$NON-NLS-1$ //$NON-NLS-2$ 
		}
		node_ = node;
		properties_ = node_.getProperties();
		id_ = id;
		removed_ = null;
	}

	/* (non-Javadoc)
	 * @see org.unitarou.sgf.cmd.Command#execute()
	 */
	@Override
	public void execute() {
		super.execute();
		removed_ = node_.removeProperty(id_);
		if (removed_ == null) {
			throw new IllegalStateException("Cannot remove property. property = " + id_); //$NON-NLS-1$
		}
	}

	/* (non-Javadoc)
	 * @see org.unitarou.sgf.cmd.Command#undo()
	 */
	@Override
	public void undo() {
		super.undo();
		for (int i = 0; i < properties_.length; ++i) {
		    node_.removeProperty(properties_[i].getId());
		}
		for (int i = 0; i < properties_.length; ++i) {
			node_.addProperty(properties_[i]);
		}
		removed_ = null;
	}
}
