/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf.io;

import java.io.File;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.unitarou.io.FileSnapshot;
import org.unitarou.lang.Exceptions;
import org.unitarou.lang.Logging;
import org.unitarou.lang.Strings;
import org.unitarou.lang.Logging.Level;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.Sgfs;
import org.unitarou.sgf.parser.SgfParser;
import org.unitarou.sgf.parser.SgfParserException;
import org.unitarou.sgf.parser.SgfParserLogger;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.type.ProblemProperties;
import org.unitarou.sgf.type.ProblemProperties.Flag;
import org.unitarou.sgf.util.BasicFinder;
import org.unitarou.sgf.util.filter.BasicFilter;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.util.FilterException;
import org.unitarou.util.StopWatch;

/**
 * FileȂǂ̃\[XCollectionԂ|Wg\łB
 * ŃLbVpĂ܂B
 * 
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public final class CollectionRepository {
	/** ̃NX̃VOgCX^XłB*/
	static private final CollectionRepository instance_s_ = new CollectionRepository();
	
	/** ̃NX̃OCX^XłB*/
	static private final Log log_s_ = LogFactory.getLog(CollectionRepository.class);
	
	/** ut@C"{0}"ǂݍ߂܂ł(RF{1})Bv */
	static private final MessageResource NT_CANT_READ_FILE
			= new MessageResource(CollectionRepository.class, "ntCantReadFile"); //$NON-NLS-1$
	
	/** uWƂĕsȌ`łBRNV̂Qڈȍ~͖܂B܂ҏW͕ʖŕۑ܂Bv*/
	static private final MessageResource NT_BAD_TYPE_FOR_DRILL; 

	/** uWŎw肵t@C݂܂łBv*/
	static private final MessageResource NT_FILE_NOT_FOUND_IN_DRILL; 

	/** uWŎw肵t@CɋlȊÕf[^݂܂B̃f[^͖܂Bv*/
	static private final MessageResource NT_FILE_IS_NOT_PROBLEM; 


	static  {
	    NT_BAD_TYPE_FOR_DRILL = new MessageResource(SgfParser.class, "ntBadTypeForDrill"); //$NON-NLS-1$
	    NT_FILE_NOT_FOUND_IN_DRILL = new MessageResource(SgfParser.class, "ntFileNotFoundInDrill"); //$NON-NLS-1$
	    NT_FILE_IS_NOT_PROBLEM = new MessageResource(SgfParser.class, "ntFileIsNotProblem"); //$NON-NLS-1$
	}
	static public CollectionRepository instance() {
		return instance_s_;
	}
	
	/**
	 * {@link #load(File)}œǂݍ񂾃t@CLbV܂B
	 */
	private final Map<File, SoftReference<Collection>> fileCacheMap_;

	/**
	 * {@link #loadProblem(Collection)}ŖVbtƂɎg܂B
	 */
    private final Random random_;

	/**
	 * 
	 */
	private CollectionRepository() {
		super();
		fileCacheMap_ = new HashMap<File, SoftReference<Collection>>();
		random_ = new Random();
	}
	
	/**
	 * file{@link Collection}ǂݏoĕԂ܂B<br>
	 * ԂCX^X͓ŕʂăLbV܂B
	 * ̃t@Cw肳ꂽꍇ́ÃLbV𕡎ʂĕԂ܂B
	 * ȂǂݏoɎsꍇ{@link org.unitarou.sgf.RootGameTree}0
	 * G[ORNVԂ܂B
	 * 
	 * @param file ǂݏot@CB
	 * @return ǂݏoꂽCollection NOT NULL
	 */
	@Logging(level = Level.TRACE, contents = "t@CELbV̓ǂݍݎ") //$NON-NLS-1$
	public Collection load(File file) {
		ArgumentChecker.throwIfNull(file);
		StopWatch stopWatch = new StopWatch();
		SgfParser sgfParser = new SgfParser();
		try {
			SoftReference<Collection> sr = fileCacheMap_.get(file);
			Collection cached = (sr != null) ? sr.get() : null;
			if ((cached == null) || !isSameContents(cached.getFileSnapshot(), file)){
				Collection collection = sgfParser.parse(file);
				fileCacheMap_.put(file, new SoftReference<Collection>(new Collection(collection)));
				if (log_s_.isTraceEnabled()) {
					log_s_.trace("Loaded " + stopWatch.stopSecond() + " secs for " + file);  //$NON-NLS-1$//$NON-NLS-2$
				}
				return collection;
			}
			if (log_s_.isTraceEnabled()) {
				log_s_.trace("Cache  " + stopWatch.stopSecond() + " secs for " + file);  //$NON-NLS-1$//$NON-NLS-2$
			}
			return new Collection(cached);

		} catch (SgfParserException e) {
			SgfParserLogger logger = new SgfParserLogger();
			logger.info(0, 
					NT_CANT_READ_FILE.get(
							file.getAbsoluteFile(), 
							Exceptions.getRootMessage(e)), 
					Strings.EMPTY);
			log_s_.debug("Instracted unreadable file:" + file.getAbsolutePath(), e); //$NON-NLS-1$
			return new Collection();
		}
	}

	/**
	 * Q̈̃t@CA̒gĂꍇ<code>true</code>Ԃ܂B<br>
	 * ŁuvƂ́F
	 * <ul>
	 * <li>ŵ({@link File#equals(java.lang.Object)}Ɠ)</li>
	 * <li>^CX^v</li>
	 * <li>t@CTCY</li>
	 * </ul>
	 * ƒ`At@CۂɊJĒg̊mF܂ł͂܂B
	 * 
	 * @param snapshot
	 * @param file2
	 * @return Q̃t@CLɂē̏ꍇ<code>true</code>B
	 *           ȂÂǂ炩ł<code>null</code>̏ꍇ<code>false</code>ԂB
	 */
	private boolean isSameContents(FileSnapshot snapshot, File file2) {
		if ((snapshot == null) || (file2 == null)) {
			return false;
		}
		return snapshot.equals(new FileSnapshot(file2));
	}

	/**
     * collectionW̏ꍇɁAeǂݏoĕKvłΉ],Vbts܂B<br>
     * {@link Collection#getFile()}<code>null</code>̏ꍇ͊e肪ǂݏoȂ̂ŉ܂B
     * 
     * ̓IɂGT[4]̖Wɑ΂āF
     * <ol>
     * <li>擪ȊORootGameTree폜(ꉞxOo)</li>
     * <li>擪(܂W)IFS^Ot@CIēǂݍ</li>
     * <li>eCollection`FbNāAGT[3]łΌ݂̃RNV̖ɒǉB
     * @  ̍ۂɁAPPS[]ȂǂWJĊeRootGameTreeɐݒ肷B</li>
     * <li>ȂAPPS[]̐ݒɂẮARootGameTreȅԂVbtB</li>
     * </ol>
     * 
     * @throws org.unitarou.lang.NullArgumentException <code>null</code>̏ꍇ
     */
    public void loadProblem(Collection collection) {
    	ArgumentChecker.throwIfNull(collection);
        // ̂AWȊOAt@Cꍇ͉ȂB
        if ( (collection.size() < 1)
                || !collection.get(0).getGameType().equals(GameType.DRILL)
                || (collection.getFile() == null)) {
            return;
        }
        StopWatch stopWatch = new StopWatch();
        SgfParserLogger logger = collection.getParserLog();

        //ifŃNAꂤ̂łŕێĂB
        File rootPath = collection.getFile();
        
        // RootGameTree1ȏ̏ꍇ́Ac()ĵŁA
        // ̎|OɏoBȂALmV^Ŋ́A
        // ̂悤ȏ󋵂͂ȂB
        if (1 < collection.size()) {
            while (collection.size() < 1) {
                collection.remove(collection.get(collection.size() - 1));
            }
            // ㏑ۑȂ悤Ƀt@CNA[B
            collection.setFile(null);
            logger.warn(1, NT_BAD_TYPE_FOR_DRILL.get(), Strings.EMPTY);
        }

        RootGameTree rootGameTree = collection.get(0);
        String[] paths = BasicFinder.findData(rootGameTree.getSequence(), SgfId.INPUT_FILES);
        paths = (paths == null) ? new String[0] : paths;
        String value = BasicFinder.findDatum(rootGameTree.getSequence(), SgfId.PROBLEM_PROPERTIES);
        ProblemProperties pp = ProblemProperties.parsePpQuietly(value);
        for (String path : paths) {
        	path = Sgfs.unescapeIfForRead(path);
            File file = new File(rootPath.getParent(), path);
            if (!file.exists() || !file.isFile()) {
                logger.warn(1, NT_FILE_NOT_FOUND_IN_DRILL.get(), file.getPath());
                continue;
            }
            appendProblem(collection, file, pp);
        }
        
        // Q[̃Vbt
        if (pp.contains(Flag.SHUFFLE)) {
            final int problemSize = collection.size() - 1; //ŏ͐ݒȂ̂
            for (int i = 1; i < problemSize; ++i) {
                RootGameTree rgt = collection.get(random_.nextInt(problemSize) + 1);
                collection.remove(rgt);
                collection.addLast(rgt);
            }
        }
        if (log_s_.isTraceEnabled()) {
        	log_s_.trace("Costs " + stopWatch.stopSecond() + " secs");  //$NON-NLS-1$//$NON-NLS-2$
        }
    }

    /**
     * file̋lcollectionɒǉ܂B
     * p[XG[̓Oɏo܂B
     * @param collection
     * @param file
     */
    private void appendProblem(Collection collection, File file, ProblemProperties pp) {
        Collection problems = load(file);
        SgfParserLogger logger = problems.getParserLog();
        for (int i = 0; i < problems.size(); ++i) {
            RootGameTree rootGameTree = problems.get(i);
            if (!rootGameTree.getGameType().equals(GameType.PROBLEM)) {
                logger.info(0, NT_FILE_IS_NOT_PROBLEM.get(), String.valueOf(i + 1));
                continue;
            }
            try {
                if (pp.contains(Flag.MIRROR_ROTATE)) {
                    // 8̓}WbNio[ۂ
                    BasicFilter.mirrorRotate(rootGameTree, random_.nextInt(8));
                }
                collection.addLast(rootGameTree);
                
            } catch (FilterException e1) {
                // TODO Auto-generated catch block
                e1.printStackTrace();
            }
        }
    }	
}
