/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf.io.dl;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.unitarou.ml.MessageResource;

/**
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class Board2chDownloader extends DefaultHttpDownloader {
	
	/**uQ˂v*/
	static private final MessageResource LB_NAME
			= new MessageResource(Board2chDownloader.class, "lbName"); //$NON-NLS-1$
	
	/**uX̒ov*/
	static private final MessageResource LB_STATUS_EXTRACT_RES
			= new MessageResource(Board2chDownloader.class, "lbStatusExtractRes"); //$NON-NLS-1$
	
	/**u<a>^O̒uv*/
	static private final MessageResource LB_STATUS_REPLACE_A_TAG
			= new MessageResource(Board2chDownloader.class, "lbStatusReplaceATag"); //$NON-NLS-1$

	/**
	 * 2chHTML̂AX𔲂oK\łB
	 */
	static private final Pattern patternRes_s_ = Pattern.compile("<dd>(.*)$", Pattern.MULTILINE); //$NON-NLS-1$

	/**
	 * 2chHTML̂A<a>^O𔲂oK\łB
	 */
	static private final Pattern patternATag_s_ = Pattern.compile("<a.*>(.*)</a>"); //$NON-NLS-1$
	
	/**
	 * 
	 */
	static private final Pattern patternUrl_s_ = Pattern.compile("http://\\w+\\.2ch\\.net/"); //$NON-NLS-1$

	/**
	 * 
	 */
	public Board2chDownloader() {
		super();
	}

	/* (non-Javadoc)
	 * @see org.unitarou.sgf.io.dl.DefaultHttpDownloader#displayName()
	 */
	@Override
	public String displayName() {
		return LB_NAME.get();
	}

	/* (non-Javadoc)
	 * @see org.unitarou.sgf.io.DefaultHttpDownloader#findSgf(java.lang.String)
	 */
	@Override
	protected CharSequence findSgf(CharSequence contents) {
	    // ȉ2chp
	    notifyListener(new HttpDownloadEvent(this, LB_STATUS_EXTRACT_RES.get(), 20));
	    Matcher matcher = patternRes_s_.matcher(contents);
	    StringBuilder sbData = new StringBuilder(contents.length());
	    while (matcher.find()) {
	    	sbData.append(matcher.group(1));
	    }
	    return sbData.toString();
	}

	/* (non-Javadoc)
	 * @see org.unitarou.sgf.io.DefaultHttpDownloader#replaceHtmlElements(java.lang.String)
	 */
	@Override
	protected CharSequence replaceHtmlElements(CharSequence sgfText) {
		sgfText = super.replaceHtmlElements(sgfText);
	    notifyListener(new HttpDownloadEvent(this, LB_STATUS_REPLACE_A_TAG.get(), 20));
	    sgfText = patternATag_s_.matcher(sgfText).replaceAll("$1"); //$NON-NLS-1$
		return sgfText;
	}

	/* (non-Javadoc)
	 * @see org.unitarou.sgf.io.dl.DefaultHttpDownloader#matches(java.lang.String)
	 */
	@Override
	public int matches(String url) {
		return patternUrl_s_.matcher(url).find() ? 10 : -10; 
	}
}
