/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf.io.dl;

import java.util.EventObject;

import org.unitarou.lang.Classes;
import org.unitarou.lang.Strings;
import org.unitarou.util.ArgumentChecker;

/**
 * {@link org.unitarou.sgf.io.dl.HttpDownloader#download(String)}
 * CxgێNXłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class HttpDownloadEvent extends EventObject {
	
	/**
	 * 
	 */
	private static final long serialVersionUID = -3091534676682098141L;
	
	
	private final String status_;
	private final int delta_;

	/**
	 * @param source
	 */
	public HttpDownloadEvent(Object src) {
		this(src, Strings.EMPTY);
	}

	/**
	 * @param source
	 */
	public HttpDownloadEvent(Object src, String status) {
		this(src, status, 0);
	}

	/**
	 * @param source
	 * @param delta 
	 */
	public HttpDownloadEvent(Object src, String status, int delta) {
		super(src);
		ArgumentChecker.throwIfNull(src, status);
		status_ = status;
		delta_ = delta;
	}

	/**
	 * Proguress̐ixԂ܂B
	 * ̒l肦܂B
	 * @return Returns the progress.
	 */
	public int getDelta() {
		return delta_;
	}

	/**
	 * @return Returns the status.
	 */
	public String getStatus() {
		return status_;
	}

	/* (non-Javadoc)
	 * @see java.util.EventObject#toString()
	 */
	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();
		sb.append(Classes.simpleName(this.getClass()))
		  .append('[')
		  .append("status_ = ").append(status_).append(',') //$NON-NLS-1$
		  .append("progress_ = ").append(delta_).append(']'); //$NON-NLS-1$
		return sb.toString();
	}
}
