/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf.io.dl;

import org.unitarou.sgf.Collection;
import org.unitarou.util.Provider;

/**
 * 
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public interface HttpDownloader extends Provider {
	
	/**
	 * url_E[hsAʂCollectionɕԂ܂B
	 * _E[hɎsꍇ͗O𑗏o܂B
	 * _E[hꂽX|XɊ݂Ȃꍇ́A
	 * vf0{@link Collection}Ԃ܂B
	 * 
	 * @param url
	 * @return
	 */
	Collection download(String url) throws HttpDownloaderException;
	
	/**
	 * urlƕ}b`sAKxԂ܂B
	 * p^[vꍇ͂Oȏ̐ԂĂB<br>
	 * vȂꍇ͕̐ԂĂB
	 * DownloaderOȏ̐Ԃꍇ́Ałl̑傫
	 * CX^XI܂B
	 * @param url
	 * @return
	 */
	int matches(String url);
	
	/**
	 * @param listener
	 */
	void addListener(HttpDownloaderListener listener);
	
	/**
	 * @param listener
	 */
	boolean removeListener(HttpDownloaderListener listener);
}
