/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf.io.dl;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.regex.Pattern;

import org.apache.commons.httpclient.Header;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.unitarou.ml.MessageResource;

/**
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class WeiqiDownloader extends DefaultHttpDownloader {
	static private final Log log_s_  = LogFactory.getLog(WeiqiDownloader.class);

	/**
	 * 
	 */
	static private final Pattern patternUrl_s_ = Pattern.compile("http://weiqi[\\.\\w]*\\.tom\\.com/"); //$NON-NLS-1$

	/**uv*/
	static private final MessageResource LB_NAME;
			
	
	static private final Charset charset_s_;
	
	static  {
		LB_NAME = new MessageResource(WeiqiDownloader.class, "lbName"); //$NON-NLS-1$
		Charset charset;
		try {
			charset = Charset.forName("GB2312"); //$NON-NLS-1$
		} catch (IllegalCharsetNameException e) {
			charset = Charset.defaultCharset();
			log_s_.warn(e.getMessage() + " Use default charset: " + charset.displayName()); //$NON-NLS-1$
		}
		charset_s_ = charset;
	}
	/**
	 * 
	 */
	public WeiqiDownloader() {
		super();
	}
	
	/* (non-Javadoc)
	 * @see org.unitarou.sgf.io.dl.DefaultHttpDownloader#displayName()
	 */
	@Override
	public String displayName() {
		return LB_NAME.get();
	}


	
	/* (non-Javadoc)
	 * @see org.unitarou.sgf.io.dl.DefaultHttpDownloader#getCharset(org.apache.commons.httpclient.Header[], java.nio.ByteBuffer)
	 */
	@Override
	protected Charset getCharset(Header[] headers, ByteBuffer byteBuffer) {
		return charset_s_;
	}

	/* (non-Javadoc)
	 * @see org.unitarou.sgf.io.dl.DefaultHttpDownloader#replaceHtmlElements(java.lang.String)
	 */
	@Override
	protected CharSequence replaceHtmlElements(CharSequence sgfText) {
		return sgfText;
	}

	/* (non-Javadoc)
	 * @see org.unitarou.sgf.io.dl.DefaultHttpDownloader#matches(java.lang.String)
	 */
	@Override
	public int matches(String url) {
		return patternUrl_s_.matcher(url).find() ? 10 : -10;
	}
}
