/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf.parser;

import java.nio.charset.Charset;

/**
 * GR[fBOɎsꍇɑo܂B
 * {@link #getNewCharset()}͎̃GR[_[܂B
 * 
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class BadCharsetException extends Exception {

	
	/**
	 * 
	 */
	private static final long serialVersionUID = 2470835382140594586L;
	
	private final Charset newCharset_;

	/**
     * 
     */
    public BadCharsetException() {
        super();
        newCharset_ = null;
    }

    /**
     * @param newCharset
     */
    public BadCharsetException(Charset newCharset) {
        super();
        newCharset_ = newCharset;
    }

	/**
	 * ̃GR[_[Ԃ܂B
	 * oɂ͕Ȃꍇ́AnullԂ܂B
	 * @return Returns the newCharset.
	 */
	public Charset getNewCharset() {
		return newCharset_;
	}
}
