/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf.parser;

import java.io.File;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.Sgfs;
import org.unitarou.sgf.Value;
import org.unitarou.sgf.type.SgfCharset;
import org.unitarou.util.ArgumentChecker;

/**
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class SgfFormatter {
	/** ̃NX̃K[łB*/
    static private final Log log_s_;
	
    /**
     * {@link #parse(File)}œǂݏoۂ̃ftHg̃fR[hp̕GR[hłB
     * O\[XĂ̂́AEɑΉ邽߂łB
     */
    static private final MessageResource SP_DEFAULT_ENCODE_CHARSET;
    
    /**
     * {@link #SP_DEFAULT_ENCODE_CHARSET}ɑΉZbgCX^Xێ܂B
     * sȖOE݂ȂOꍇ̓VXẽftHgR[hɂȂ܂B
     */
	static public final Charset DEFAULT_ENCODE_CHARSET;

	static  {
	    log_s_ = LogFactory.getLog(SgfFormatter.class);
	    SP_DEFAULT_ENCODE_CHARSET = new MessageResource(SgfFormatter.class, "spDefaultEncodeCharset"); //$NON-NLS-1$
	    Charset charset = null;
	    try {
	        charset = Charset.forName(SP_DEFAULT_ENCODE_CHARSET.get());
	        if (!charset.canEncode()) {
	            charset = Charset.defaultCharset();
	            log_s_.warn("Bad argument, needs encodable charset:" //$NON-NLS-1$
	            			+ SP_DEFAULT_ENCODE_CHARSET.get()
	            			+ ". Use default charset" + charset.displayName());  //$NON-NLS-1$
	        }
	    } catch (IllegalArgumentException e) {
            log_s_.warn("Unknown charset:" + SP_DEFAULT_ENCODE_CHARSET.get()); //$NON-NLS-1$
            charset = Charset.defaultCharset();
	    }
	    DEFAULT_ENCODE_CHARSET = charset;
	}
	
	
	private boolean writeRegularId_;
	private StringWriter writer_;

	/**
     * 
     */
    public SgfFormatter() {
        super();
        writeRegularId_ = false;
    }
    
	/**
	 * collection{@link ByteBuffer}ɕϊ܂B<br>
	 * ߂l{@link ByteBuffer}position0ɃZbgĂ܂B
	 * 
	 * ܂AwriteRegularIdtrueɂƁASGF̋Kɏ]悤IDϊĕۑ܂B
	 * writeRegularIdfalsȅꍇ́Aǂݍ񂾏ԂȂׂێĕۑ悤Ƃ܂B
	 * 
	 * @param collection
	 * @throws NullPointerException nullꍇB
	 */
	public ByteBuffer format(Collection collection) {
		ArgumentChecker.throwIfNull(collection);
	
		// eRootGameTreeByteBuffer܂B
		List<ByteBuffer> byteBuffers = new ArrayList<ByteBuffer>(collection.size());
		int totalByte = 0;
		for (int i = 0; i < collection.size(); ++i) {
			writer_ = new StringWriter();
			RootGameTree rgt = collection.get(i);
			if (0 == rgt.getSequence().size()) {
				continue;
			}
			SgfCharset sgfCharset = rgt.getSgfCharset();
			if (sgfCharset == null) {
				sgfCharset = new SgfCharset(rgt.getActualCharset());
			}
			Charset charset = sgfCharset.getCharset();
			if (!charset.canEncode()) {
				sgfCharset = new SgfCharset(Charset.defaultCharset());
			}
			rgt.setCharset(sgfCharset);
			format(rgt);
			writer_.flush();
			
			ByteBuffer byteBuffer = sgfCharset.getCharset().encode(writer_.toString());
			byteBuffers.add(byteBuffer);
			totalByte += byteBuffer.limit();
		}
		
		ByteBuffer ret = ByteBuffer.allocate(totalByte);
		for (Iterator ip = byteBuffers.iterator(); ip.hasNext();) {
            ByteBuffer buffer = (ByteBuffer)ip.next();
            ret.put(buffer);
            
        }
		ret.rewind();
		return ret;
	}
	
	/**
	 * PcollectionSGFɕϊ܂B<br>
	 * t@C(R[hӎoCg)ۂɂ
	 * {@link #format(Collection)}𗘗p܂B
	 * @param collection
	 * @return
	 * @throws NullPointerException nullꍇB
	 */
	public String formatAsString(Collection collection) {
		ArgumentChecker.throwIfNull(collection);
		
		writer_ = new StringWriter();
		for (int i = 0; i < collection.size(); ++i) {
			RootGameTree rootTree = collection.get(i);
			if (0 == rootTree.getSequence().size()) {
				continue;
			}
			format(rootTree);
		}
		writer_.flush();
		return writer_.toString();
	}
	
	/**
	 * gameTreeȉo܂B
	 */
	private void format(GameTree gameTree) {
	    writer_.write(gameTree.getOpenUtr());
		writer_.write(Sgfs.GAME_TREE_START_MARK);
		
		Node[] nodes = gameTree.getSequence().getNodes();
		for (int i = 0; i < nodes.length; ++i) {
			format(nodes[i]);
		}

		GameTree[] children = gameTree.getChildren();
		for (int i = 0; i < children.length; ++i) {
			format(children[i]);
		}
		writer_.write(Sgfs.GAME_TREE_END_MARK);
	    writer_.write(gameTree.getCloseUtr());
	}
	
	/**
	 * nodeȉo܂B
	 */
	private void format(Node node) {
		writer_.write(node.getOpenUtr());
		writer_.write(Sgfs.NODE_START_MARK);
		Property[] properties = node.getProperties();
		for (int i = 0 ; i < properties.length; ++i) {
			format(properties[i]);
		}
	}
	
	/**
	 * propertyȉo܂B
	 */
	private void format(Property property) {
		writer_.write(property.getOpenUtr());
		writer_.write(writeRegularId_ ?	property.getId() : property.getEntireId());
		
		//TODO IIII
		Value[] values = property.getValues();
		if (property.sgfId().equals(SgfId.INPUT_FILES)) {
			for (int i = 0; i < values.length; ++i) {
			    writer_.write(values[i].getOpenUtr());
				writer_.write(Sgfs.VALUE_START_MARK);
				writer_.write(Sgfs.escapeIfForStore(values[i].getString()));
				writer_.write(Sgfs.VALUE_END_MARK);
			}

		} else {
			for (int i = 0; i < values.length; ++i) {
			    writer_.write(values[i].getOpenUtr());
				writer_.write(Sgfs.VALUE_START_MARK);
				writer_.write(Sgfs.escapeForStore(values[i].getString()));
				writer_.write(Sgfs.VALUE_END_MARK);
			}
		}
		writer_.write(property.getCloseUtr());
	}
}
