/* 
 * Copyright 2004, 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;

import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Collection;
import org.unitarou.util.ArgumentChecker;

/**
 * ReaderSGFt@CǂݍŁA
 * (SGFŒ`Ă)CollectionIuWFNgɕϊp[TłB
 * DOMX^C(t@C̒gSɃIuWFNg)łB
 * 
 * @author UNITAROU &lt;boss@unitarou.org&gt;
 */
public class SgfParser {
	/** ̃NX̃K[łB*/
    static private final Log log_s_;
    

	/**
     * {@link #parse(File)}œǂݏoۂ̃ftHg̃fR[hp̕GR[hłB
     * O\[XĂ̂́AEɑΉ邽߂łB
     */
    static private final MessageResource SP_DEFAULT_DECODE_CHARSET;

    /**
     * {@link #SP_DEFAULT_ENCODE_CHARSET}ɑΉZbgCX^Xێ܂B
     * sȖOE݂ȂOꍇ̓VXẽftHgR[hɂȂ܂B
     */
	static public final Charset DEFAULT_DECODE_CHARSET;

	/** ut@CrŐ؂Ă̂ŁA\Ȍǂݍ݂܂Bv*/
	static private final MessageResource NT_INPUT_TERMINATED;
	

	/**
	 * statictB[h̒ɐ̂ŁA
	 * staticCjVCUpĂB
	 */
	static {
	    log_s_ = LogFactory.getLog(SgfParser.class);
	    SP_DEFAULT_DECODE_CHARSET = new MessageResource(SgfParser.class, "spDefaultDecodeCharset"); //$NON-NLS-1$
	    NT_INPUT_TERMINATED = new MessageResource(SgfParser.class, "ntInputTerminated"); //$NON-NLS-1$
	    Charset charset = null;
	    try {
	        charset = Charset.forName(SP_DEFAULT_DECODE_CHARSET.get());

	    } catch (IllegalArgumentException e) {
            log_s_.warn("Unknown charset:" + SP_DEFAULT_DECODE_CHARSET.get()); //$NON-NLS-1$
            charset = Charset.defaultCharset();
	    }
	    DEFAULT_DECODE_CHARSET = charset;
	}
	
    private final SgfParserCore sgfParserBase_;
    private Charset defaultCharset_;
	/**
	 * 
	 */
	public SgfParser() {
		super();
		sgfParserBase_ = new SgfParserCore();
		defaultCharset_ = DEFAULT_DECODE_CHARSET;
	}

    /**
     * @param defaultCharset The defaultCharset to set.
     */
    public void setDefaultCharset(Charset defaultCharset) {
        ArgumentChecker.throwIfNull(defaultCharset);
        defaultCharset_ = defaultCharset;
    }
    
    /**
     * @return Returns the defaultCharset.
     */
    public Charset getDefaultCharset() {
        return defaultCharset_;
    }
    
	/**
	 * OœsĂB
	 * 
	 * @param reader BufferedReaderpĂ̂ŁAbv͕svłB
	 * @return
	 * @throws SgfParserException t@Cǂݍݎɉ炩̌ŃG[ꍇB
	 * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
	 * @deprecated ̃\bhreaderw肷ƁAVM̃ftHgȊO̕R[hɑΉł܂B
	 *               {@link #parse(File)}{@link #parseImpl(ByteBuffer)}gĂB
	 */
	@Deprecated
	public Collection parse(Reader reader) throws SgfParserException {
	    ArgumentChecker.throwIfNull(reader);
	    sgfParserBase_.setParserLogger(new SgfParserLogger());
	    sgfParserBase_.setReader(reader);
		try {
		    sgfParserBase_.setInputTerminated(false);
			Collection collection = new Collection();

			while(sgfParserBase_.parseCollection(collection)) {
			    // Ȃ
			}
			
			if (sgfParserBase_.isInputTerminated()) {
			    sgfParserBase_.writeWarningLog(NT_INPUT_TERMINATED, new Object());
			}

			collection.setParserLog(sgfParserBase_.getParserLogger());
			return collection;	 
			
		} catch (IOException e) {
			throw new SgfParserException(e);
		}
	}
	
	/**
	 * stringvbgtH[̃ftHgR[h
	 * GR[hĂp[X܂B
	 * @param string
	 * @return
	 * @throws SgfParserException
	 */
	public Collection parse(String string) throws SgfParserException {
		return parse(string, defaultCharset_);
	}
	
	/**
	 * string𕶎R[hw肵
	 * GR[hĂp[X܂B
	 * @param string
	 * @return
	 * @throws SgfParserException
	 */
	public Collection parse(String string, Charset charset) throws SgfParserException {
		ArgumentChecker.throwIfNull(string);
	    sgfParserBase_.setParserLogger(new SgfParserLogger());
		ByteBuffer buffer = charset.canEncode() 
				? charset.encode(string) 
				: ByteBuffer.wrap(string.getBytes());
		return parseImpl(buffer, charset);
	}

	/**
	 * OœsĂB
	 * 
	 * @param file ǂݏot@C
	 * @return
	 * 
	 * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
	 * @throws SgfParserException 炩̗RŃp[XɎsꍇ
	 */
	public Collection parse(File file) throws SgfParserException {
	    ArgumentChecker.throwIfNull(file);
	    sgfParserBase_.setParserLogger(new SgfParserLogger());
		return parseImpl(file);
	}
	
	/**
	 * t@Cp[X܂B
	 * @param file
	 * @return
	 * @throws SgfParserException
	 */
	private Collection parseImpl(File file) throws SgfParserException {
	    FileInputStream fileInputStream = null;
	    try {
	        fileInputStream = new FileInputStream(file);
	        FileChannel fileChannel = fileInputStream.getChannel();
		    if (0x7FFFFFFF < fileChannel.size()) {
	            throw new SgfParserException("Can't open file because of large size."); //$NON-NLS-1$
		    }
		    ByteBuffer byteBuffer = ByteBuffer.allocate((int)fileChannel.size());
		    fileChannel.read(byteBuffer);
		    Collection collection = parseImpl(byteBuffer, defaultCharset_);
		    collection.setFile(file);
		    return collection;
		    
        } catch (IOException e) {
            throw new SgfParserException(e);
            
        } finally {
        	IOUtils.closeQuietly(fileInputStream);
	    }
	}
	
	/**
	 * 
	 * 
	 * @param reader BufferedReaderpĂ̂ŁAbv͕svłB
	 * @return
	 * @throws SgfParserException t@Cǂݍݎɉ炩̌ŃG[ꍇB
	 * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
	 */
	private Collection parseImpl(ByteBuffer byteBuffer, Charset charset) throws SgfParserException {
	    ArgumentChecker.throwIfNull(byteBuffer);
	    
	    sgfParserBase_.setByteBuffer(byteBuffer, charset);
		try {
		    sgfParserBase_.setInputTerminated(false);
			Collection collection = new Collection();

			while(sgfParserBase_.parseCollection(collection)) {
			    // Ȃ
			}
			
			if (sgfParserBase_.isInputTerminated()) {
			    sgfParserBase_.writeWarningLog(NT_INPUT_TERMINATED, new Object());
			}

			collection.setParserLog(sgfParserBase_.getParserLogger());
			return collection;	 
			
		} catch (IOException e) {
			throw new SgfParserException(e);
		}
	}


}