/* 
 * Copyright 2004 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf.parser;

import java.util.ArrayList;
import java.util.List;

import org.unitarou.lang.UEnum;
import org.unitarou.util.ArgumentChecker;


/**
 * {@link org.unitarou.sgf.parser.SgfParser}ł̃p[X̃OێB<br>
 * ʂ̃K[ɂȂ̂́AƂŃO[UɌ邱Ƃz肵Ă̂ŁA
 * `낦Kv邽߁B
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class SgfParserLogger {
    
    /** Ox肷񋓌^ */
    static public class Level extends UEnum {
        /** x̃N(傫قǏd) */
        private final int rank_;
        protected Level(int rank, String typeName) {
            super(typeName);
            rank_ = rank;
        }
        /** x̃N(傫قǏd)Ԃ܂B */
        public int getRank() {
            return rank_;
        }
    }

    /** 񃌃x(N0) */
    static public final Level INFO = new Level(0, "INFO"); //$NON-NLS-1$

    /** xx(N1000) */
    static public final Level WARN = new Level(1000, "WARN"); //$NON-NLS-1$

    /** Qx(N2000) */
	static public final Level ERROR = new Level(2000, "ERROR"); //$NON-NLS-1$
    
    
    /** bZ[WЂƂi[B*/
    static public class Message {
        /** bZ[W̃x */
        private final Level level_; 
        
        /** bZ[W̑ΏۂƂȂt@C̍sԍ(PIW) */
        private final int line_;
        
        /** [JCYꂽbZ[W{ */
        private final String message_;
        
        /** bZ[W̑ΏۂƂȂf[^ */
        private final String fragment_;
        
        /**
         * 
         */
        public Message(Level level, int line, String message, String fragment) {
            super();
            level_ = level;
            line_ = line;
            message_ = message;
            fragment_ = fragment;
        }
        
        /** bZ[W̃x(INFO, WARN, ERROR)ԂB */
        public Level getLevel() {
            return level_;
        }

        /** bZ[W̑ΏۂƂȂt@C̍sԍ(PIW)ԂB*/
        public int getLine() {
            return line_;
        }

        /** [JCYꂽbZ[W{ԂB */
        public String getMessage() {
            return message_;
        }

        /** bZ[W̑ΏۂƂȂf[^ԂB */
        public String getFragment() {
            return fragment_;
        }
    }
    
    /** ^[{@link SgfParserLogger.Message}]*/
    private final List<Message> messages_; 
    /**
     * 
     */
    public SgfParserLogger() {
        super();
        messages_ = new ArrayList<Message>();
    }

    /**
     * ̃NX̃Rs[RXgN^łB
	 * @param parserLog
	 */
	public SgfParserLogger(SgfParserLogger src) {
		ArgumentChecker.throwIfNull(src);
		messages_ = new ArrayList<Message>(src.messages_);
	}

	/**
     * @throws org.unitarou.lang.NullArgumentException null̏ꍇB
     */
    public void addMessage(Message message) {
        ArgumentChecker.throwIfNull(message);
        messages_.add(message);
    }
    
    public void error(int line, String message, String fragment) {
        addMessage(new Message(ERROR, line, message, fragment));
    }

    public void warn(int line, String message, String fragment) {
        addMessage(new Message(WARN, line, message, fragment));
    }
    
    public void info(int line, String message, String fragment) {
        addMessage(new Message(INFO, line, message, fragment));
    }

    /**
     * levelȏ̃NbZ[WԂ܂B
     * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
     */
    public Message[] getMessages(Level level) {
        ArgumentChecker.throwIfNull(level);
        
        List<Message> ret = new ArrayList<Message>(messages_.size());
        for (int i = 0; i < messages_.size(); ++i) {
            Message message = messages_.get(i);
            if (level.rank_ <= message.level_.rank_) {
                ret.add(message);
            }
        } 
        return ret.toArray(new Message[ret.size()]);
    }
    
    /** NɊ֌WȂׂẴbZ[WԂ܂B*/
    public Message[] getAllMessages() {
        return messages_.toArray(new Message[messages_.size()]);
    }
    
    
}
