/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf.parser;

import java.io.IOException;
import java.nio.charset.Charset;

/**
 * {@link org.unitarou.sgf.parser.SgfParserCore}ŗp
 * [_[̃C^[tFCXłB
 * java.io.Readergdg݂
 * java.nio.ByteBuffergdg݂ɐ؂ւ悤
 * @\𒊏oĂ܂B
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
interface SgfParserReader {
    /**
     * ݂̓ǂݍ݈ʒu{@link org.unitarou.sgf.RootGameTree}
     * oCgXg[̓ǂݍ݊Jnn_Ƃ܂B
     */
    public void markRootGameTree();

    /**
     * ݓǂݍł{@link org.unitarou.sgf.RootGameTree}̕Zbgݒ肵܂B
     * [UR[hCA^OiKł̃\bhĂяo܂B
     * {@link #markRootGameTree()}ĂяoꂽɊɈx
     * ĂяoĂꍇA݂{@link Charset}ƓꍇA
     * ܂caValueZbgƂĔFłȂꍇfalseԂ܂B
     * ȊȌꍇ́A{@link #byteBuffer_}{@link org.unitarou.sgf.RootGameTree}
     * Jnn_܂Ŋ߂trueԂ܂B
     * ɂA{@link #mark(int)}͖ɂȂ܂B
     * 
     * @param newCharse VGR[fBO
     * @return R[hύXꂽꍇtrue
     * @throws BadCharsetException 
     * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
     */
    public boolean setCharset(Charset newCharse);
    

    /**
     * 
     * @throws BadCharsetException oCiƌ݂̕R[hꗂꍇ
     * @see BufferedReader#read();
     */
    int read() throws IOException, BadCharsetException;

    void mark(int readAheadLimit) throws IOException;

    void reset() throws IOException;

    /**
     * @return
     */
    int getLineNumber();

    /**
     * ݃fR[hɗpĂ镶ZbgԂ܂B
     */
    public Charset getCharset();

    /**
     * [_[̃ftHg̕ZbgԂ܂B
     * @return
     */
    public Charset getDefaultCharset();

}