/* 
 * Copyright 2004 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf.parser;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;

import org.unitarou.sgf.Collection;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.Sgfs;
import org.unitarou.sgf.Value;

/**
 * @deprecated ̃tH[}b^[͕Zbg̕ύXɑΉł܂B
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
@Deprecated
public class SgfStringFormatter {

	private BufferedWriter writer_;
	private boolean enableCaElement_;
	private boolean writeRegularId_;

	/**
     * 
     */
    public SgfStringFormatter() {
        super();
    }
    
	/**
	 * collectionwriterɏ݂܂B<br>
	 * enableCaElementtruȅꍇA{@link OutputStreamWriter#getEncoding()}pCA[`]ɏ݂܂B
	 * enableCaElementfalsȅꍇAY^O͍폜܂B
	 * 
	 * ܂AwriteRegularIdtrueɂƁASGF̋Kɏ]悤IDϊĕۑ܂B
	 * writeRegularIdfalsȅꍇ́Aǂݍ񂾏ԂȂׂێĕۑ悤Ƃ܂B
	 * TODO writer̃GR[fBOȂׂʓIȖ̂ɂȂ悤ɂ
	 * TODO static\bhĂяo悤ɕύX
	 * TODO ݏNX쐬iCAAIDAs̃^C~OjB
	 * 
	 * @param collection
	 * @param writer
	 * @throws NullPointerException nullꍇB
	 */
	public void format(Collection collection, Writer writer, 
						boolean enableCaElement, boolean writeRegularId) 
			throws SgfParserException {
		
	    try {
			writer_ = new BufferedWriter(writer);
			enableCaElement_ = enableCaElement;
			writeRegularId_ = writeRegularId;
			if ((collection == null) || (writer == null)) {
				throw new NullPointerException();
			} 
		
			for (int i = 0; i < collection.size(); ++i) {
				GameTree rootTree = collection.get(i);
				if (0 == rootTree.getSequence().size()) {
					continue;
				}
				
				Node node = rootTree.getSequence().getFirst();
				if (enableCaElement_) {//FIXME GR[fBO
				    //					node.addProperty(new Property(SgfId.CHARSET.id, writer.getEncoding()));
				} else {
					node.removeProperty(SgfId.CHARSET.id());					
				}
				format(rootTree);
			}
			writer_.flush();
			
		} catch (IOException e) {
			throw new SgfParserException(e);

		} finally {
			writer_ = null;
		}
	}
	
	/**
	 * gameTreeȉo܂B
	 * @throws IOException
	 */
	private void format(GameTree gameTree) throws IOException {
	    writer_.write(gameTree.getOpenUtr());
		writer_.write(Sgfs.GAME_TREE_START_MARK);
		
		Node[] nodes = gameTree.getSequence().getNodes();
		for (int i = 0; i < nodes.length; ++i) {
			format(nodes[i]);
		}

		GameTree[] children = gameTree.getChildren();
		for (int i = 0; i < children.length; ++i) {
			format(children[i]);
		}
		writer_.write(Sgfs.GAME_TREE_END_MARK);
	    writer_.write(gameTree.getCloseUtr());
	}
	
	/**
	 * nodeȉo܂B
	 * @throws IOException
	 */
	private void format(Node node) throws IOException {
		writer_.write(node.getOpenUtr());
		writer_.write(Sgfs.NODE_START_MARK);
		Property[] properties = node.getProperties();
		for (int i = 0 ; i < properties.length; ++i) {
			format(properties[i]);
		}
	}
	
	/**
	 * propertyȉo܂B
	 * @throws IOException
	 */
	private void format(Property property) throws IOException {
		writer_.write(property.getOpenUtr());
		writer_.write(writeRegularId_ ?	property.getId() : property.getEntireId());
		
		Value[] values = property.getValues();
		for (int i = 0; i < values.length; ++i) {
		    writer_.write(values[i].getOpenUtr());
			writer_.write(Sgfs.VALUE_START_MARK);
			writer_.write(escapeBracket(values[i].getString()));
			writer_.write(Sgfs.VALUE_END_MARK);
		}
		writer_.write(property.getCloseUtr());
	}
	
	/**
	 * GXP[vs܂B
	 * Value̐f[^oۂɁA'\'݂ꍇ́A
	 * ̂̕܂܏o܂B݂̕Ȃꍇ'\'t܂B
	 * ܂A']'ꍇ͎O'\'݂͂܂B
	 * @return
	 */
	private String escapeBracket(String value) {
		StringBuilder escaped = new StringBuilder();
		StringCharacterIterator ip = new StringCharacterIterator(value);
		char c = ip.first();
		while(c != CharacterIterator.DONE) {
		    if (c == Sgfs.ESCAPE_SOFT_LINE_BREAK) {
		        escaped.append(c);
		        c = ip.next();
		        if (c == CharacterIterator.DONE) {
			        escaped.append(Sgfs.ESCAPE_SOFT_LINE_BREAK);
		            break;
		        }
		    } else if (c == Sgfs.VALUE_END_MARK) {
				escaped.append(Sgfs.ESCAPE_SOFT_LINE_BREAK);
			}
			escaped.append(c);
			c = ip.next();
		}
		return escaped.toString();
	}
}
