/* 
 * Copyright 2004, 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf.parser;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;

/**
 * {@link java.io.LineNumberReader}̂悤ɏɁA
 * s ('\n')╜A ('\r')܂Ƃ߂ȂAsV̗ǂ[_[łB
 * {@link #getLineNumber()}ŕԂsԍ͂PIWłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 * @deprecated ̃[_pƕR[h̎w肪ł܂B
 * @@@@@@@{@link org.unitarou.sgf.parser.NioReader}pĂB
 */
@Deprecated 
class WellbehavedLineNumberReader implements SgfParserReader {
    
    /** ۂɃf[^i[Ă郊[_[łB */
    private final BufferedReader bufferedReader_;
    
    
    /** Pn܂sԍłB*/
    private int lineNumber_ = 1;
    
    /** Ōɓǂݍ񂾕CR('\r')̏ꍇtrueɂȂĂtOłB */
    private boolean isLastCharacterCR_ = false;
    
    /** {@link #mark(int)}ꂽ_ł{@link #lineNumber_}łB*/
    private int markedLineNubmer_ = -1;
    
    /** {@link #mark(int)}ꂽ_ł{@link #isLastCharacterCR_}łB*/
    private boolean markedIsLastCharacterCR_;

    /**
     * @param in
     */
    public WellbehavedLineNumberReader(Reader in) {
        super();
        bufferedReader_ = new BufferedReader(in);
    }


    /* (non-Javadoc)
     * @see org.unitarou.sgf.parser.SgfParserReader#markRootGameTree()
     */
    public void markRootGameTree() {
        // TODO Auto-generated method stub
        
    }


    /* (non-Javadoc)
     * @see org.unitarou.sgf.parser.SgfParserReader#setCharset(java.lang.String)
     */
    public boolean setCharset(String caValue) {
        // TODO Auto-generated method stub
        return false;
    }
    
    /* (non-Javadoc)
     * @see org.unitarou.sgf.parser.SgfParserReader#getCharset()
     */
    public Charset getCharset() {
        return Charset.forName("Windows-31J"); //$NON-NLS-1$
    }

    /**
     * 
     * @see BufferedReader#read();
     */
    public int read() throws IOException {
        int character = bufferedReader_.read();
        countLineNumber(character);
        return character;
    }
    
   
    private void countLineNumber(int character) {
        if (character == '\r') {
            if (isLastCharacterCR_) {
                ++lineNumber_;
            } else {
                isLastCharacterCR_ = true;
            }
            
        } else if (character == '\n') {
            ++lineNumber_;
            isLastCharacterCR_ = false;

        } else {
            if (isLastCharacterCR_) {
                ++lineNumber_;
            }
            isLastCharacterCR_ = false;
        }
    }

    
    public void mark(int readAheadLimit) throws IOException {
        bufferedReader_.mark(readAheadLimit);
        markedLineNubmer_ = lineNumber_;
        markedIsLastCharacterCR_ = isLastCharacterCR_;
    }
    
    public void reset() throws IOException {
        bufferedReader_.reset();
        lineNumber_ = markedLineNubmer_;
        isLastCharacterCR_ = markedIsLastCharacterCR_;
    }
    /**
     * @return
     */
    public int getLineNumber() {
        return lineNumber_;
    }


	/* (non-Javadoc)
	 * @see org.unitarou.sgf.parser.SgfParserReader#setCharset(java.nio.charset.Charset)
	 */
	public boolean setCharset(Charset newCharse) {
		// TODO Auto-generated method stub
		return false;
	}


	/* (non-Javadoc)
	 * @see org.unitarou.sgf.parser.SgfParserReader#getDefaultCharset()
	 */
	public Charset getDefaultCharset() {
		// TODO Auto-generated method stub
		return null;
	}
}
