/* 
 * Copyright 2004 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf.parser.push;

import java.io.IOException;
import java.io.Reader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

import org.unitarou.sgf.Collection;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.Sequence;
import org.unitarou.sgf.parser.BadCharsetException;
import org.unitarou.sgf.parser.SgfParserCore;
import org.unitarou.sgf.parser.SgfParserException;
import org.unitarou.sgf.parser.SgfParserLogger;

/**
 * PushX^C(Cxghu)SGFt@Cp[Xp[TłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class SgfPushParser extends SgfParserCore {
    
    /** ^[{@link SgfPushParserListener}]*/
    private final Set<SgfPushParserListener> listeners_;
    /**
     * 
     */
    public SgfPushParser() {
        super();
        listeners_ = new HashSet<SgfPushParserListener>(); 
    }
    
    /**
     * <code>null</code>⓯IuWFNg̓o^͖܂B
     * o^listener͕K{@link #removeListener(SgfPushParserListener)}
     * 폜悤ɂ܂傤B
     */
    public void addListener(SgfPushParserListener listener) {
        if (listener == null) {
            return;
        }
        listeners_.add(listener);
    }
    
    /** 폜ɐtrueԂ܂B*/
    public boolean removeListener(SgfPushParserListener listener) {
        return listeners_.remove(listener);
    }
    
    private boolean fireSequenceListener(Sequence sequence, boolean canContinue) {
        boolean listenersVoice = canContinue;
        for (Iterator ip = listeners_.iterator(); ip.hasNext(); ) {
            listenersVoice 
            	&= ((SgfPushParserListener)ip.next())
            			.sequenceParsed(sequence, canContinue);
        }
        return (canContinue & listenersVoice);
    }
    
    private boolean fireNodeListener(Node node, boolean canContinue) {
        boolean listenersVoice = canContinue;
        for (Iterator ip = listeners_.iterator(); ip.hasNext(); ) {
            listenersVoice 
            	&= ((SgfPushParserListener)ip.next())
            		.nodeParsed(node, canContinue);
        }
        return (canContinue & listenersVoice);
    }

    /**
     * p[XfԂ܂B
     * @throws SgfParserException IOG[ȂǂꍇB
     */
    public Collection parseWithModel(Reader reader) throws SgfParserException {
		setParserLogger(new SgfParserLogger());
        Collection collection = new Collection();
        setReader(reader);
        try {
			while(parseCollection(collection)) {
			    // Ȃ
			}
        } catch (IOException e) {
            throw new SgfParserException(e);
        }
        return collection;
    }
    
    
    /* (non-Javadoc)
     * @see org.unitarou.sgf.parser.SgfParserBase#parseSequence(org.unitarou.sgf.RootGameTree, org.unitarou.sgf.GameTree, org.unitarou.sgf.Sequence)
     */
    @Override
	public boolean parseSequence(RootGameTree root, GameTree parent, Sequence sequence) 
    		throws IOException, BadCharsetException {
        boolean canContinue = super.parseSequence(root, parent, sequence);
        return fireSequenceListener(sequence, canContinue);
    }

    /* (non-Javadoc)
     * @see org.unitarou.sgf.parser.SgfParserBase#parseNode(org.unitarou.sgf.Node)
     */
    @Override
	public boolean parseNode(Node node, StringBuilder utr) 
    		throws IOException, BadCharsetException {
        boolean canContinue = super.parseNode(node, utr);
        return fireNodeListener(node, canContinue);
    }
}
