/* SgfPushParserListener.java
 * 
 * Copyright 2004 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf.parser.push;

import java.util.EventListener;

import org.unitarou.sgf.Node;
import org.unitarou.sgf.Sequence;

/**
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public interface SgfPushParserListener extends EventListener {
    /**
     * PV[PX̃p[XIƌĂяo܂B
     * @param sequence p[XꂽV[PXB
     * @param canContinue Ƀp[XłꍇtrueAp[XIĂfalseĂ܂B
     * @return p[XŏIꍇfalseݒ肵܂B
     *          p[Tɓo^Ă郊Xi[̂ǂꂩłfalseԂƁA
     *          p[X͏I܂B
     */
    boolean sequenceParsed(Sequence sequence, boolean canContinue);
    
    /**
     * Pm[h̃p[XIƌĂяo܂B
     * @param node p[Xꂽm[h
     * @param canContinue Ƀp[XłꍇtrueAp[XIĂfalseĂ܂B
     * @return p[XŏIꍇfalseݒ肵܂B
     *          p[Tɓo^Ă郊Xi[̂ǂꂩłfalseԂƁA
     *          p[X͏I܂B
     */
    boolean nodeParsed(Node node, boolean canContinue);
}
