/* 
 * Copyright 2004, 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf.type;

import org.unitarou.lang.NullArgumentException;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.Sgfs;
import org.unitarou.util.ArgumentChecker;

/**
 * AP^O̒gێ܂B
 * 
 * @author UNITAROU &lt;boss@unitarou.org&gt;
 */
public class Application implements TypedString {
    
    /**
     * value{@link Application}𐶐p[TłB
     * @param value
     * @return
     * @throws TypeParseException
     */
    static public Application parse(String value) throws TypeParseException {
		if (value == null) {
			throw new TypeParseException();
		}
        return  new Application(value);
    }
    
	static public Application create(String name, String version) {
		if (name == null || version == null) {
			throw new NullArgumentException();
		}
		return new Application(name, version);
	}
	
	private final String name_;
	private final String version_;
	private Application(String name, String version) {
		super();
		assert(name != null && version != null);
		name_ = name;
		version_ = version;
	}
	/**
	 * 
	 */
	private Application(String value) {
		super();
		assert(value != null);
		
		int sepIndex = value.indexOf(Sgfs.COMPOSE_SEPARATOR);
		if (0 < sepIndex) {
			name_ = value.substring(0,sepIndex);
			version_ = value.substring(sepIndex + 1);
		} else {
			name_ = value;
			version_ = null;
		}
	}

	/**
	 * {@link SgfId#APPLICATION}̂ݎ󂯕t܂
	 * @see org.unitarou.sgf.type.TypedString#acceptable(org.unitarou.sgf.SgfId)
	 */
	public boolean acceptable(SgfId sgfId) {
		ArgumentChecker.throwIfNull(sgfId);
		return sgfId.equals(SgfId.APPLICATION);
	}
	
	/* (non-Javadoc)
	 * @see org.unitarou.sgf.type.TypedString#getString()
	 */
	public String getString() {
	    StringBuilder stringBuffer = new StringBuilder(name_);
	    if (version_ != null) {
	        stringBuffer.append(':').append(version_);
	    }
	    return stringBuffer.toString();
	}
	
	public String name() {
		return name_;
	}
	
	public String version() {
		return version_;
	}

	/* (non-Javadoc)
	 * @see java.lang.Comparable#compareTo(java.lang.Object)
	 */
	public int compareTo(Object o) {
		Application app = (Application)o;
		return name_.compareTo(app.name_);
	}
}
