/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf.type;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.unitarou.lang.NameDisplayable;
import org.unitarou.ml.Messages;
import org.unitarou.sgf.SgfId;
import org.unitarou.util.ArgumentChecker;

/**
 * FF^O̒lɈӖt^tlNXłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public enum FileFormat implements TypedString<FileFormat>, NameDisplayable {
 	VERSION_1(1),
	VERSION_2(2),
	VERSION_3(3),
	VERSION_4(4);

 	static private Log log_s_ = LogFactory.getLog(FileFormat.class);
	static private final Pattern condition_s_ = Pattern.compile("1|2|3|4"); //$NON-NLS-1$
	static private final int POS = 0; //K\̃O[vID

	static public FileFormat parse(String value) throws TypeParseException {
		Matcher matched = condition_s_.matcher(value);
		if (!matched.matches()) {
			throw new TypeParseException("Bad argument value = " + value); //$NON-NLS-1$
		}
		String ff = matched.group(POS);
		for (FileFormat fileFormat : FileFormat.values()) {
			if (fileFormat.string_.equals(ff)) {
				return fileFormat;
			}
		}
		log_s_.info("Unknown FileFormat: " + ff + ". Use FF[4] instead"); //$NON-NLS-1$ //$NON-NLS-2$
		return VERSION_4;
	}

	private final String string_;
    /**
     * @param typeName
     */
    FileFormat(int id) {
    	string_ = String.valueOf(id);
    }

    /* (non-Javadoc)
	 * @see org.unitarou.sgf.type.Type#getValue()
	 */
	public String getString() {
		return string_;
	}

	/**
	 * {@link SgfId#FILE_FORMAT}̂ݎ󂯕t܂B
	 * 
	 * @see org.unitarou.sgf.type.TypedString#acceptable(org.unitarou.sgf.SgfId)
	 */
	public boolean acceptable(SgfId sgfId) {
		ArgumentChecker.throwIfNull(sgfId);
		return SgfId.FILE_FORMAT.equals(sgfId);
	}

	
	/* (non-Javadoc)
	 * @see java.lang.Enum#toString()
	 */
	@Override
	public String toString() {
		return displayName();
	}

	/* (non-Javadoc)
	 * @see org.unitarou.lang.NameDisplayable#displayName()
	 */
	public String displayName() {
        Messages messages = Messages.createByPackage(getClass());
        return messages.get(Messages.createKey(getClass(), string_));	
	}
}
