/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf.type;

import org.unitarou.ml.NamedEnumByMessages;
import org.unitarou.sgf.SgfId;
import org.unitarou.util.ArgumentChecker;

/**
 * GMvpeB̒l\NXłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class GameMode extends NamedEnumByMessages implements TypedString {

 	static public final GameMode IGO 						= new GameMode(1); //$NON-NLS-1$
	static public final GameMode OTHELLO 					= new GameMode(2); //$NON-NLS-1$
	static public final GameMode CHESS 					= new GameMode(3); //$NON-NLS-1$
	static public final GameMode GOMOKU_RENJU 			= new GameMode(4); //$NON-NLS-1$
	static public final GameMode NINE_MENS_MORRIS 		= new GameMode(5); //$NON-NLS-1$
	static public final GameMode BACKGAMMON  				= new GameMode(6); //$NON-NLS-1$
	static public final GameMode CHINESECHESS 			= new GameMode(7); //$NON-NLS-1$
	static public final GameMode SHOGI 					= new GameMode(8); //$NON-NLS-1$
	static public final GameMode LINES_OF_ACTION 			= new GameMode(9); //$NON-NLS-1$
	static public final GameMode ATAXX 					= new GameMode(10); //$NON-NLS-1$
	static public final GameMode HEX 						= new GameMode(11); //$NON-NLS-1$
	static public final GameMode JUNGLE 					= new GameMode(12); //$NON-NLS-1$
	static public final GameMode NEUTRON 					= new GameMode(13); //$NON-NLS-1$
	static public final GameMode PHILOSOPHERS_FOOTBALL	= new GameMode(14); //$NON-NLS-1$
	static public final GameMode QUADRATURE 				= new GameMode(15); //$NON-NLS-1$
	static public final GameMode TRAX  					= new GameMode(16); //$NON-NLS-1$
	static public final GameMode TANTRIX 					= new GameMode(17); //$NON-NLS-1$
	static public final GameMode AMAZONS 					= new GameMode(18); //$NON-NLS-1$
	static public final GameMode OCTI 					= new GameMode(19); //$NON-NLS-1$
	static public final GameMode GESS	 					= new GameMode(20); //$NON-NLS-1$
	static public final GameMode TWIXT  					= new GameMode(21); //$NON-NLS-1$
	static public final GameMode ZERTZ  					= new GameMode(22); //$NON-NLS-1$
	static public final GameMode PLATEAU 					= new GameMode(23); //$NON-NLS-1$

    /**
     * @param datum
     * @return
     */
    static public GameMode parse(String datum) {
        try {
            SgfNumber id = new SgfNumber(Integer.parseInt(datum));
            return (GameMode)find(GameMode.class, id);
            
        } catch (NumberFormatException ignore) {
            // ȂB
        }
        return null;
    }

    /**
     * @param typeName
     */
    protected GameMode(int id) {
        super(new SgfNumber(id));
    }

    /* (non-Javadoc)
     * @see org.unitarou.sgf.type.Type#getValue()
     */
    public String getString() {
        return typeName().toString();
    }

	/**
	 * {@link SgfId#GAME_MODE}̂ݎ󂯕t܂B
	 * 
	 * @see org.unitarou.sgf.type.TypedString#acceptable(org.unitarou.sgf.SgfId)
	 */
	public boolean acceptable(SgfId sgfId) {
		ArgumentChecker.throwIfNull(sgfId);
		return SgfId.GAME_MODE.equals(sgfId);
	}
}
