/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf.type;

import org.unitarou.lang.NameDisplayable;
import org.unitarou.ml.Messages;
import org.unitarou.sgf.SgfId;
import org.unitarou.util.ArgumentChecker;

/**
 * lƕ\L(0:ݐA1:A2:qȂ)Rt邽߂ɃTuNXĂ܂B
 * 
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class Handicap extends SgfNumber implements NameDisplayable {
	static private final Messages messages_s_ = Messages.createByPackage(Handicap.class);

	/**
	 * @param number
	 */
	public Handicap(int number) {
		super(number);
	}

	/* (non-Javadoc)
	 * @see org.unitarou.lang.NameDisplayable#displayName()
	 */
	public String displayName() {
		String key = Messages.createKey(Handicap.class, getString());
		if (messages_s_.contains(key)) {
			return messages_s_.get(key);
		}
		return String.valueOf(getIntValue());
	}

	/**
	 * {@link SgfId#HANDICAP}̂ݎ󂯕t悤ɐe\bh㏑܂B
	 * 
	 * @see org.unitarou.sgf.type.TypedString#acceptable(org.unitarou.sgf.SgfId)
	 */
	@Override
	public boolean acceptable(SgfId sgfId) {
		ArgumentChecker.throwIfNull(sgfId);
		return SgfId.HANDICAP.equals(sgfId);
	}
}
