/* 
 * Copyright 2004, 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf.type;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.Sgfs;
import org.unitarou.util.ArgumentChecker;

/**
 * SGFLBx̒lbvCX^XłB
 * 
 * @author UNITAROU &lt;boss@unitarou.org&gt;
 */
public class Label implements TypedString {
    static private final Log log_s_ = LogFactory.getLog(Label.class);
	static private final Pattern condition_s_ = Pattern.compile("([a-zA-Z]{2})\\s*:(.*)"); //$NON-NLS-1$
	static private final int POSITION_POS = 1; //K\̃O[vID
	static private final int LABEL_POS = 2; //K\̃O[vID

	/**
	 * valuePɑO̍Wƌ㔼̃bZ[WɕzԂ܂B
	 * {@link SgfSize}擾ɐl擾ꍇɗp܂B
	 * 
	 * @return vfQStringzAvf[0]͍WAvf[1]̓x
	 * @throws TypeParseException valuep[XłȂꍇ
	 */
	static public String[] parseString(String value) throws TypeParseException {
		Matcher matched = condition_s_.matcher(value);
		if (!matched.matches()) {
			throw new TypeParseException("Bad argument value=\'" + value + '\''); //$NON-NLS-1$
		}
		return new String[]{matched.group(POSITION_POS), matched.group(LABEL_POS)};
	}
	/**
	 * @throws TypeParseException valuep[XłȂꍇ
	 * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
	 */
	static public Label parse(SgfSize size, String value) throws TypeParseException {
	    ArgumentChecker.throwIfNull(size, value);
	    
		String[] parsed = parseString(value);
		return  new Label(SgfPoint.parseMove(size, parsed[0]), SimpleText.parse(parsed[1]));
	}
	
    /**
	 * {@link TypeParseException}𑗏oȂɁA
	 * p[XɎsꍇnullԂ܂B
     * @param size
     * @param string
     * @return
     */
    public static Label parseQuietly(SgfSize size, String value) {
	    try {
	        return parse(size, value);
	    } catch (TypeParseException e) {
	        log_s_.debug("Bad value for parse: " + value, e); //$NON-NLS-1$
            return null;

	    } catch (IllegalArgumentException e) {
	        log_s_.debug("Bad value for parse: " + value, e); //$NON-NLS-1$
            return null;
	    }
    }
	
	private final SgfPoint point_;
	private final SimpleText label_;
	/**
	 * 
	 */
	public Label(SgfPoint point, SimpleText simpleText) {
		super();
		point_ = point;
		label_ = simpleText;
	}
	
	/**
	 * {@link SgfId#LABEL}̂ݎ󂯕t܂B
	 * 
	 * @see org.unitarou.sgf.type.TypedString#acceptable(org.unitarou.sgf.SgfId)
	 */
	public boolean acceptable(SgfId sgfId) {
		ArgumentChecker.throwIfNull(sgfId);
		return SgfId.LABEL.equals(sgfId);
	}
	
	/* (non-Javadoc)
	 * @see org.unitarou.sgf.type.TypedString#getString()
	 */
	public String getString() {
		StringBuilder sb = new StringBuilder();
		sb.append(point_.getString());
		sb.append(Sgfs.COMPOSE_SEPARATOR);
		sb.append(label_.getString());
		return sb.toString();
	}

	public SgfPoint getPoint() {
        return point_;
    }

    public SimpleText getLabel() {
        return label_;
    }

	/**
	 * @param value
	 * @return
	 */
	public boolean isValid(String value) {
		return (value != null) ? condition_s_.matcher(value).matches() : false;
	}

	/* (non-Javadoc)
	 * @see java.lang.Comparable#compareTo(java.lang.Object)
	 */
	public int compareTo(Object o) {
		Label obj = (Label)o;
		return point_.compareTo(obj.point_); //ꏊ̏ꍇ͏㏑O
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if ( (obj == null) || (!(obj instanceof Label))) {
			return false;

		} else if (this == obj) {
			return true;

		} else {
			Label o = (Label)obj;
			return point_.equals(o.point_);
		}			
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		return point_.hashCode();
	}
}
