/* None.java
 * 
 * Copyright 2004 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf.type;

import org.unitarou.lang.Strings;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.ValueType;
import org.unitarou.util.ArgumentChecker;

/**
 * @author UNITAROU &lt;boss@unitarou.org&gt;
 */
public class None implements TypedString {
	static public final None INSTANCE = new None(); 
	static private final String value_s_ = Strings.EMPTY;

	/**
	 * 
	 */
	private None() {
		super();
	}

	/* (non-Javadoc)
	 * @see org.unitarou.sgf.type.Type#getValue()
	 */
	public String getString() {
		return value_s_;
	}

	/* (non-Javadoc)
	 * @see org.unitarou.sgf.type.Type#isValid(java.lang.String)
	 */
	public boolean isValid(String value) {
		return (value_s_.equals(value));
	}

	/* (non-Javadoc)
	 * @see java.lang.Comparable#compareTo(java.lang.Object)
	 */
	public int compareTo(Object o) {
		return 0;
	}
	
	/**
	 * {@link SgfId#valueType()}{@link ValueType#NONE}̂ݎ󂯕t܂B
	 * 
	 * @see org.unitarou.sgf.type.TypedString#acceptable(org.unitarou.sgf.SgfId)
	 */
	public boolean acceptable(SgfId sgfId) {
		ArgumentChecker.throwIfNull(sgfId);
		return ValueType.NONE.equals(sgfId.valueType());
	}
}
