/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf.type;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.SgfId;
import org.unitarou.util.ArgumentChecker;

/**
 * LmV^̃IWi^OłPP(Ver1łPPS)̌^NXłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class ProblemProperties extends SgfNumber {
    public enum Flag {
    	/** qg\ꍇ'1'rbgłB*/
    	SHOW_HINT(0x01),
    	
    	/** ̏Ԃւꍇ'1'rbgłB*/
    	SHUFFLE(0x02),

    	/** 蒼ꍇ'1'rbgłB*/
    	RETRYABLE(0x04),

    	/** Ԃ݂ꍇ'1'rbgłB*/
    	TIME_LIMIT(0x08),

    	/** ̉]⎲̓ւꍇ'1'rbgłB*/
    	MIRROR_ROTATE(0x10),

    	/** OČ_\ꍇ'1'rbgłB*/
    	SHOW_ENDPOINT(0x20);
    	
    	/**
    	 * flag̔zrbgORʂԂ܂B
    	 * @param flags
    	 * @return
    	 */
    	static public int toIntValue(Flag... flags) {
    		int ret = 0;
    		for (Flag flag : flags) {
    			ret = ret | flag.value_;
    		}
    		return ret;
    	}
    	
    	private final int value_;
    	private final MessageResource messageResource_;
    	
    	Flag(int value) {
    		value_ = value;
    		messageResource_ = new MessageResource(this.getClass(), String.valueOf(value));
    	}
    	
    	public int getValue() {
    		return value_;
    	}
    	
    	public String getDisplayName() {
    		return messageResource_.get();
    	}
    }

    

    static private final Log log_s_ = LogFactory.getLog(ProblemProperties.class);
	static private final Pattern condition_s_ = Pattern.compile("\\d+"); //$NON-NLS-1$

	/**
	 * valuep[X{@link ProblemProperties}CX^X쐬ĕԂ܂B
	 * {@link ProblemProperties}ƂĔFłȂꍇ́ATypeParseExceptionOo܂B
	 * ߂lnullԂƂ͂܂B
	 * @throws org.unitarou.lang.NullArgumentException valuenull̏ꍇ
	 */
	static public ProblemProperties parsePp(String value) throws TypeParseException {
	    ArgumentChecker.throwIfNull(value);
		Matcher matched = condition_s_.matcher(value);
		if (!matched.matches()) {
			throw new TypeParseException("Bad argument value = " + value); //$NON-NLS-1$
		}
		return new ProblemProperties(Integer.parseInt(matched.group()));
	}

	/**
	 * {@link #parse(String)}ƈႢ{@link TypeParseException}𑗏oȂɁA
	 * ϊɎsꍇɂ<code>new ProblemProperties(0)</code>Ԃp[TłB 
	 * @param value
	 * @return
	 * @throws org.unitarou.lang.NullArgumentException valuenull̏ꍇ
	 */
	static public ProblemProperties parsePpQuietly(String value) {
	    ArgumentChecker.throwIfNull(value);
	    try {
            return parsePp(value);
        } catch (TypeParseException e) {
	        log_s_.debug("Unknown value for ProblemProperties: " + value, e); //$NON-NLS-1$
	        return new ProblemProperties(0);
        }
	}
	
	

	
	private final EnumSet<Flag> enumSet_;
	
    /**
     * @param number
     */
    public ProblemProperties(int number) {
        super(number);
        enumSet_ = EnumSet.<Flag>noneOf(Flag.class);
        EnumSet<Flag> set = EnumSet.<Flag>allOf(Flag.class);
        for (Flag flag : set) {
        	if ((flag.value_ & number) != 0) {
        		enumSet_.add(flag);
        	}
        }
    }
    
    /**
     * tOw肵č\z܂B
     * @param flags
     */
    public ProblemProperties(Flag... flags) {
    	super(Flag.toIntValue(flags));
    	enumSet_ = EnumSet.copyOf(Arrays.asList(flags));
    }
	
    /**
	 * {@link SgfId#PROBLEM_PROPERTIES}̂ݎ󂯕t悤ɐe\bh㏑܂B
	 * 
	 * @see org.unitarou.sgf.type.TypedString#acceptable(org.unitarou.sgf.SgfId)
	 */
	@Override
	public boolean acceptable(SgfId sgfId) {
		ArgumentChecker.throwIfNull(sgfId);
		return SgfId.PROBLEM_PROPERTIES.equals(sgfId);
	}
	
	
    public boolean contains(Flag flag) {
    	ArgumentChecker.throwIfNull(flag);
    	return enumSet_.contains(flag);
    }
}
