/* 
 * Copyright 2004 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf.type;

import java.nio.charset.Charset;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.unitarou.sgf.SgfId;
import org.unitarou.util.ArgumentChecker;

/**
 * @author UNITAROU &lt;boss@unitarou.org&gt;
 */
public final class SgfCharset implements TypedString<SgfCharset> {
	static private final Log log_s_ = LogFactory.getLog(SgfCharset.class);
	static public SgfCharset parse(String value) {
		return new SgfCharset(value);
	}

	private Charset charset_;
	
	/**
	 * charsetCX^X쐬܂B
	 * @param charset
	 * @throws org.unitarou.lang.NullArgumentException  <code>null</code>̏ꍇ
	 */
	public SgfCharset(Charset charset) {
		ArgumentChecker.throwIfNull(charset);
		charset_ = charset;
	}
	
	/**
	 * @param value
	 */
	private SgfCharset(String value) {
		super();
		try {
			charset_ = Charset.forName(value);
			
		} catch(IllegalArgumentException e) {
			charset_ = Charset.defaultCharset();
			log_s_.warn(value + " is not a valid charset name. Use default chaset:" + charset_, e); //$NON-NLS-1$
		}
	}
	
	public Charset getCharset() {
		return charset_;
	}

	/**
	 * {@link SgfId#CHARSET}̂ݎ󂯕t܂
	 * @see org.unitarou.sgf.type.TypedString#acceptable(org.unitarou.sgf.SgfId)
	 */
	public boolean acceptable(SgfId sgfId) {
		ArgumentChecker.throwIfNull(sgfId);
		return sgfId.equals(SgfId.CHARSET);
	}
	
	/* (non-Javadoc)
	 * @see org.unitarou.sgf.type.TypedString#getString()
	 */
	public String getString() {
		return charset_.name();
	}

	/* (non-Javadoc)
	 * @see java.lang.Comparable#compareTo(T)
	 */
	public int compareTo(SgfCharset o) {
		return charset_.compareTo(o.charset_);
	}
}
