/* 
 * Copyright 2004, 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf.type;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.unitarou.lang.UEnum;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.ValueType;
import org.unitarou.util.ArgumentChecker;

/**
 * SGFDouble^(12lŁA{x_ł͂Ȃ)bvNXłB
 * 
 * @author UNITAROU &lt;boss@unitarou.org&gt;
 */
public class SgfDouble extends UEnum implements TypedString {
    static private final Log log_s_ = LogFactory.getLog(SgfDouble.class);
    
	static public final SgfDouble NORMAL = new SgfDouble("1"); //$NON-NLS-1$
	static public final SgfDouble EMPHASIZED = new SgfDouble("2"); //$NON-NLS-1$

	static private final Pattern condition_s_ = Pattern.compile("1|2"); //$NON-NLS-1$
	static private final int POS = 0; //K\̃O[vID

	/**
	 * 
	 * @param value
	 * @return
	 * @throws TypeParseException
	 * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
	 */
	static public SgfDouble parse(String value) throws TypeParseException {
	    ArgumentChecker.throwIfNull(value);
		Matcher matched = condition_s_.matcher(value);
		if (!matched.matches()) {
			throw new TypeParseException("Bad argument value = " + value); //$NON-NLS-1$
		}
		String doudle = matched.group(POS);
		return doudle.equals(NORMAL.typeName()) ? NORMAL : EMPHASIZED;
	}
	
	/**
	 * {@link TypeParseException}𑗏oȂɕsȒlnullԂ܂B
	 * @param value
	 * @return
	 * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
	 */
	static public SgfDouble parseQuietly(String value) {
	    try {
	        return parse(value);
	    } catch (TypeParseException e) {
	        log_s_.debug("Bad value for parse: " + value, e); //$NON-NLS-1$
            return null;
	    }
	}
	

	static public boolean isValid(String value) {
		Matcher matched = condition_s_.matcher(value);
		return matched.matches();
	}

	/**
	 * 
	 */
	private SgfDouble(String value) {
		super(value);
	}

	/**
	 * {@link SgfId#valueType()}{@link ValueType#DOUBLE}̂ݎ󂯕t܂B
	 * 
	 * @see org.unitarou.sgf.type.TypedString#acceptable(org.unitarou.sgf.SgfId)
	 */
	public boolean acceptable(SgfId sgfId) {
		ArgumentChecker.throwIfNull(sgfId);
		return ValueType.DOUBLE.equals(sgfId.valueType());
	}
	
	/* (non-Javadoc)
	 * @see org.unitarou.sgf.type.TypedString#getString()
	 */
	public String getString() {
		return typeName().toString();
	}
}
