/*  
 * Copyright 2004, 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf.type;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.unitarou.lang.Strings;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.ValueType;
import org.unitarou.util.ArgumentChecker;


/**
 * SGFɂNumber^(t)\NXłB
 * 
 * @author UNITAROU &lt;boss@unitarou.org&gt;
 */
public class SgfNumber implements TypedString {
    static private final Log log_s_ = LogFactory.getLog(SgfNumber.class);
	static private final Pattern condition_s_ = Pattern.compile("(\\+|-)?\\d+"); //$NON-NLS-1$

	/**
	 * valuep[XNumberCX^X쐬ĕԂ܂B
	 * NumberƂĔFłȂꍇ́ATypeParseExceptionOo܂B
	 * ߂lNullԂƂ͂܂B
	 */
	static public SgfNumber parse(String value) throws TypeParseException {
		Matcher matched = condition_s_.matcher(value);
		if (!matched.matches()) {
			throw new TypeParseException("Bad argument value = " + value); //$NON-NLS-1$
		}
		return new SgfNumber(Integer.parseInt(matched.group()));
	}

	/**
	 * {@link TypeParseException}𑗏oȂɕsȒlnullԂ܂B
	 * @param value
	 * @return
	 * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
	 */
	static public SgfNumber parseQuietly(String value) {
	    try {
	        return parse(value);
	    } catch (TypeParseException e) {
	        log_s_.debug("Bad value for parse: " + value, e); //$NON-NLS-1$
            return null;
	    }
	}
	
	private final Integer number_;
	/**
	 * 
	 */
	public SgfNumber(int number) {
		super();
		number_ = new Integer(number);
	}

	/**
	 * {@link SgfId#valueType()}{@link ValueType#NUMBER}̂ݎ󂯕t܂B
	 * 
	 * @see org.unitarou.sgf.type.TypedString#acceptable(org.unitarou.sgf.SgfId)
	 */
	public boolean acceptable(SgfId sgfId) {
		ArgumentChecker.throwIfNull(sgfId);
		return ValueType.NUMBER.equals(sgfId.valueType());
	}
	
	/* (non-Javadoc)
	 * @see org.unitarou.sgf.type.TypedString#getString()
	 */
	public String getString() {
		return (number_ == null) ? Strings.EMPTY : number_.toString();
	}
	
	public int getIntValue() {
	    return number_.intValue();
	}

	/**
	 * @param value
	 * @return
	 */
	public boolean isValid(String value) {
		return condition_s_.matcher(value).matches(); 
	}

	/* (non-Javadoc)
	 * @see java.lang.Comparable#compareTo(java.lang.Object)
	 */
	public int compareTo(Object o) {
		SgfNumber obj = (SgfNumber)o;
		return number_.compareTo(obj.number_);
	}
	
	
    /* (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
	public String toString() {
        return number_.toString();
    }
    
	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
	    if (obj == this) {
	        return true;
	    }
		if ( (obj == null) || (!(obj.getClass().equals(this.getClass())))) {
			return false;
		}
		SgfNumber o = (SgfNumber)obj; 
		if (o.number_ == null) {
			return (number_ == null);
		}
		return o.number_.equals(number_);
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		return (number_ == null) ? Integer.MIN_VALUE : number_.hashCode();
	}
}
