/* SimpleText.java
 * 
 * Copyright 2004 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf.type;

import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.ValueType;
import org.unitarou.util.ArgumentChecker;

/**
 * @author UNITAROU &lt;boss@unitarou.org&gt;
 */
public class SimpleText implements TypedString {
	static public SimpleText parse(String value) {
		if ((value == null) || (value.length() == 0)) {
			throw new IllegalArgumentException();
		}
		return new SimpleText(value);
	}

	private final String text_;
	/**
	 * 
	 */
	public SimpleText(String value) {
		super();
		text_ = value;
	}


    public String getText() {
        return text_;
    }
    
	/**
	 * {@link SgfId#valueType()}{@link ValueType#SIMPLE_TEXT}̂ݎ󂯕t܂B
	 * 
	 * @see org.unitarou.sgf.type.TypedString#acceptable(org.unitarou.sgf.SgfId)
	 */
	public boolean acceptable(SgfId sgfId) {
		ArgumentChecker.throwIfNull(sgfId);
		return ValueType.SIMPLE_TEXT.equals(sgfId.valueType());
	}
	
	/* (non-Javadoc)
	 * @see org.unitarou.sgf.type.TypedString#getString()
	 */
	public String getString() {
		return text_;
	}

	/* (non-Javadoc)
	 * @see org.unitarou.sgf.type.Type#isValid(java.lang.String)
	 */
	public boolean isValid(String value) {
		return (value != null) && (value.length() != 0);
	}

	/* (non-Javadoc)
	 * @see java.lang.Comparable#compareTo(java.lang.Object)
	 */
	public int compareTo(Object o) {
		SimpleText text = (SimpleText)o;
		return text_.compareTo(text.text_);
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if ( (obj == null) || (!(obj instanceof SimpleText))) {
			return false;

		} else if (this == obj) {
			return true;

		} else {
			SimpleText text = (SimpleText)obj;
			return text_.equals(text.text_);			
		}
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		return text_.hashCode();
	}
}
