/* Style.java
 * 
 * Copyright 2004 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf.type;

import org.unitarou.ml.NamedEnumByMessages;
import org.unitarou.sgf.SgfId;
import org.unitarou.util.ArgumentChecker;


/**
 * STvpeB̒l\NXłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class Style extends NamedEnumByMessages implements TypedString {
    /**
     * ω}
     * successor node (children)ō쐬A
     * current node (siblings)ō쐬ێtOłB
     * (value &amp; BF_VARIATIONS) == 0 childrenA0ȊOsiblingsłB
     */
    static public final int BF_VARIATIONS = 0x1;

    /**
     * ω}\LՂɕ\(do board markup)A
     * Ȃ(no (auto-) board markup)ێtOłB
     * (value &amp; BF_MARKUP) == 0 Ŏ\A0ȊOŕ\łB
     */
    static public final int BF_MARKUP = 0x2;
    
    static public final Style CHILDREN_SHOW_VAL = new Style(0); 
    static public final Style SIBLINGS_SHOW_VAL = new Style(1); 
    static public final Style CHILDREN_HIDE_VAL = new Style(2); 
    static public final Style SIBLINGS_HIDE_VAL = new Style(3); 
        
    /**
     * SGFt@CST^O݂ȂƂ̃ftHgl(=0)łB
     */
    static public final Style DEFAULT = CHILDREN_SHOW_VAL; 
    
    /**
     * @param datum
     * @return
     */
    static public Style parse(String datum) {
        try {
            Integer id = Integer.decode(datum);
            return (Style)find(Style.class, id);
            
        } catch (NumberFormatException ignore) {
            // ȂB
        }
        return null;
    }

    
    private final int value_;
    protected Style(int id) {
        super(new Integer(id));
        value_ = id;
    }
    
    
    /**
     * ω}childrenX^C(V[PX̍Ōŕω}ʒm)
     * \ƂtrueԂ܂B
     * ܂siblingsX^C(V[PX̍ŏŕω}ʒm)
     * \ƂfalseԂ܂B
     * @return
     */
    public boolean isChildrenStyle() {
        return (value_ & BF_VARIATIONS) == 0;
    }
    
    /**
     * ω}p̒ՂɋLƂĕ\ꍇtrueԂ܂B
     * ł͋L\ȂꍇfalseԂ܂B 
     */
    public boolean isBoardMarkup() {
        return (value_ & BF_MARKUP) == 0;
    }

	/**
	 * {@link SgfId#STYLE}̂ݎ󂯕t܂
	 * @see org.unitarou.sgf.type.TypedString#acceptable(org.unitarou.sgf.SgfId)
	 */
	public boolean acceptable(SgfId sgfId) {
		ArgumentChecker.throwIfNull(sgfId);
		return sgfId.equals(SgfId.STYLE);
	}
	
	/* (non-Javadoc)
     * @see org.unitarou.sgf.type.TypedString#getString()
     */
    public String getString() {
        return typeName().toString();
    }
}
