/* Text.java
 * 
 * Copyright 2004 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf.type;

import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.ValueType;
import org.unitarou.util.ArgumentChecker;

/**
 * @author UNITAROU &lt;boss@unitarou.org&gt;
 */
public class Text implements TypedString {
	static public Text parse(String value) {
		if ((value == null) || (value.length() == 0)) {
			throw new IllegalArgumentException();
		}
		return new Text(value);
	}

	private final String value_;
	/**
	 * 
	 */
	public Text(String value) {
		super();
		value_ = value;
	}


	/**
	 * {@link SgfId#valueType()}{@link ValueType#TEXT}̂ݎ󂯕t܂B
	 * 
	 * @see org.unitarou.sgf.type.TypedString#acceptable(org.unitarou.sgf.SgfId)
	 */
	public boolean acceptable(SgfId sgfId) {
		ArgumentChecker.throwIfNull(sgfId);
		return ValueType.TEXT.equals(sgfId.valueType());
	}
	/* (non-Javadoc)
	 * @see org.unitarou.sgf.type.TypedString#getString()
	 */
	public String getString() {
		return value_;
	}

	/**
	 * @param value
	 * @return
	 */
	public boolean isValid(String value) {
		return (value != null) && (value.length() != 0);
	}

	/* (non-Javadoc)
	 * @see java.lang.Comparable#compareTo(java.lang.Object)
	 */
	public int compareTo(Object o) {
		Text text = (Text)o;
		return value_.compareTo(text.value_);
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if ( (obj == null) || (!(obj instanceof Text))) {
			return false;

		} else if (this == obj) {
			return true;

		} else {
			Text text = (Text)obj;
			return value_.equals(text.value_);			
		}
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		return value_.hashCode();
	}
}
