/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf.type;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.unitarou.sgf.SgfId;
import org.unitarou.util.ArgumentChecker;

/**
 * TL^O̒gێ܂B
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class TimeLapsed implements TypedString {
    static private final Log log_s_ = LogFactory.getLog(TimeLapsed.class);
    
	static private final Pattern condition_s_ = Pattern.compile("(\\d+)\\s*,\\s*(\\d+)"); //$NON-NLS-1$
	static private final int TIME_LAPSED_POS = 1; //K\̃O[vID
	static private final int TIME_DELAY_POS = 2; //K\̃O[vID

	/**
	 * valueB̂Ƃ{@link #BLACK}AW̎{@link #WHITE}Ԃ܂B
	 *
	 * @throws TypeParseException valueBłWłȂꍇ
	 * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
	 */
	static public TimeLapsed parse(String value) throws TypeParseException {
	    ArgumentChecker.throwIfNull(value);
		Matcher matched = condition_s_.matcher(value);
		if (!matched.matches()) {
			throw new TypeParseException("Bad argument value = " + value); //$NON-NLS-1$
		}
		return new TimeLapsed(Integer.parseInt(matched.group(TIME_LAPSED_POS)),
								Integer.parseInt(matched.group(TIME_DELAY_POS)));
	}
	/**
	 * {@link TypeParseException}𑗏oȂɁA
	 * p[XɎsꍇnullԂ܂B
	 * 
	 * @param value
	 * @return
	 */
	static public TimeLapsed parseQuietly(String value) {
	    try {
	        return parse(value);
	    } catch (TypeParseException e) {
	        log_s_.debug("Parse failure: ", e); //$NON-NLS-1$
	        return null;
	    }
	}
	
	/**
	 * l
	 */
	private final int timeLapsed_;
	
	/**
	 * ʐMx
	 */
	private final int timeDelay_;

	/**
	 * 
	 */
	public TimeLapsed(int timeLapsed, int timeDelay) {
		super();
		timeLapsed_ = timeLapsed;
		timeDelay_ = timeDelay;
	}

	/**
	 * @return Returns the timeLapsed.
	 */
	public int getTimeLapsed() {
		return timeLapsed_;
	}

	/**
	 * @return Returns the timeDelay.
	 */
	public int getTimeDelay() {
		return timeDelay_;
	}
	
	/**
	 * {@link SgfId#TIME_LAPSED}̂ݎ󂯕t܂
	 * @see org.unitarou.sgf.type.TypedString#acceptable(org.unitarou.sgf.SgfId)
	 */
	public boolean acceptable(SgfId sgfId) {
		ArgumentChecker.throwIfNull(sgfId);
		return sgfId.equals(SgfId.TIME_LAPSED);
	}
	
	/* (non-Javadoc)
	 * @see org.unitarou.sgf.type.TypedString#getString()
	 */
	public String getString() {
		StringBuilder stringBuilder = new StringBuilder();
		stringBuilder.append(timeLapsed_).append(',').append(timeDelay_);
		return stringBuilder.toString();
	}

	/* (non-Javadoc)
	 * @see java.lang.Comparable#compareTo(T)
	 */
	public int compareTo(Object o) {
		TimeLapsed tl = (TimeLapsed)o;
		int ret = timeLapsed_ - tl.timeLapsed_;
		if (ret != 0) {
			return ret;
		}
		return  timeDelay_ - tl.timeDelay_;
	}

}
