/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf.util;

import org.unitarou.lang.Strings;
import org.unitarou.sgf.CardinalityType;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.PropertyValue;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.Sequence;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.util.ArgumentChecker;

/**
 * SgfIuWFNg{@link org.unitarou.sgf.Collection}, 
 * {@link org.unitarou.sgf.GameTree}, {@link org.unitarou.sgf.Sequence},
 * {@link org.unitarou.sgf.Node}ɑ΂Ċ{IȌsWbNNXłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class BasicFinder {
    
    /**
     * propertydatum݂ꍇtrueԂ܂B
     * 
     * @throws org.unitarou.lang.NullArgumentException nullꍇ
     */
    static public boolean contains(Property property, String datum) {
        ArgumentChecker.throwIfNull(property, datum);
        String[] data = property.getStrings();
        for (int i = 0; i < data.length; ++i) {
            if (data[i].equals(datum)) {
                return true;
            }
        }
        return false;
    }


    /**
     * seqence̐擪ŏɌsgfTypePropertyNodeԂ܂B
     * ݂Ȃꍇ́A<code>null</code>Ԃ܂B
     * @throws org.unitarou.lang.NullArgumentException nullꍇ
     */
    static public Node findNode(Sequence sequence, SgfId sgfId) {
        ArgumentChecker.throwIfNull(sequence, sgfId);
	    
        for (Node node : sequence) {
            Property property = node.getProperty(sgfId);
            if (property != null) {
                return node;
            }
        }
        return null;
    }
	/**
     * seqence̐擪ŏɌsgfTypePropertyԂ܂B
     * ݂Ȃꍇ́A<code>null</code>Ԃ܂B
	 * @param sequence
	 * @param sgfId
	 * @return
	 */
	static public Property findProperty(Sequence sequence, SgfId sgfId) {
        ArgumentChecker.throwIfNull(sequence, sgfId);
	    
        for (Node node : sequence) {
            Property property = node.getProperty(sgfId);
            if (property != null) {
                return property;
            }
        }
        return null;
	}
    
    /**
     * seqence̐擪ŏɌsgfTypePropertyValueԂ܂B
     * ݂ȂꍇnullԂ܂B
     * 
     * @throws org.unitarou.lang.NullArgumentException nullꍇ
     */
    static public String[] findData(Sequence sequence, SgfId sgfId) {
        ArgumentChecker.throwIfNull(sequence, sgfId);

        for (Node node : sequence) {
            String[] data = findDataImpl(node, sgfId);
            if (data != null) {
                return data;
            }
        	
        }
        return null;
    }
    
    
    /**
     * nodesgfType݂ꍇɂ{@link PropertyValue#getString()}Ԃ܂B
     * ݂Ȃꍇ́A{@link Strings#EMPTY}Ԃ܂B
     */
    static private String[] findDataImpl(Node node, SgfId sgfId) {
        Property property = node.getProperty(sgfId);
        return (property != null) ? property.getStrings() : null;
    }

    /**
     * seqence̐擪ŏɌsgfTypePropertyDatumԂ܂B
     * ݂Ȃꍇ́A{@link Strings#EMPTY}Ԃ܂B
     * 
     * @throws org.unitarou.lang.NullArgumentException nullꍇ
     * @throws IllegalArgumentException sgfTypeLIST܂ELIST̏ꍇB
     */
    static public String findDatum(Sequence sequence, SgfId sgfId) {
        ArgumentChecker.throwIfNull(sequence, sgfId);
	    throwIfMultiType(sgfId);

	    for (Node node : sequence) {
            String datum = findDatumImpl(node, sgfId);
            if (!Strings.EMPTY.equals(datum)) {
                return datum;
            }
	    }
        return Strings.EMPTY;
    }
    
    /**
     * nodesgfType݂ꍇɂ{@link PropertyValue#getString()}Ԃ܂B
     * ݂Ȃꍇ́A{@link Strings#EMPTY}Ԃ܂B
     * 
     * @throws org.unitarou.lang.NullArgumentException nullꍇ
     * @throws IllegalArgumentException sgfTypeLIST܂ELIST̏ꍇB
     */
    static public String findDatum(Node node, SgfId sgfId) {
        ArgumentChecker.throwIfNull(node, sgfId);
	    throwIfMultiType(sgfId);
        return findDatumImpl(node, sgfId);
    }
    
    /**
     * nodesgfType݂ꍇɂ{@link PropertyValue#getString()}Ԃ܂B
     * ݂Ȃꍇ́A{@link Strings#EMPTY}Ԃ܂B
     */
    static private String findDatumImpl(Node node, SgfId sgfId) {
        Property property = node.getProperty(sgfId);
        return (property != null) ? property.getString() : Strings.EMPTY;
    }
    
    /**
     * sgfType{@link SgfId#cardinalityType()}{@link CardinalityType#SINGLE}ȊÔƂ
     * IllegalArgumentException𑗏o܂B
     * @throws IllegalArgumentException sgfType{@link CardinalityType#SINGLE}ȊÔƂB
     */
    static private void throwIfMultiType(SgfId sgfId) {
	    if (!CardinalityType.SINGLE.equals(sgfId.cardinalityType())) {
	        throw new IllegalArgumentException(
	                "Bad type. " + sgfId.id() + " is LIST or ELIST.");  //$NON-NLS-1$//$NON-NLS-2$
	    }
    }
    
    
    /**
     * rootGameTree̐擪̃m[h{@link SgfId#BLACK}{@link SgfId#WHITE}
     * ŏɌ΂̐FԂ܂Bω}͑SĖ{I܂B
     * m[hɗ̐΂ꍇ͔A{ɒ肪ꍇ <code>null</code>
     * Ԃ܂B
     * 
     * @param rootGameTree
     * @return
     */
    static public SgfColor firstMove(RootGameTree rootGameTree) {
    	ArgumentChecker.throwIfNull(rootGameTree);
    	return firstMoveImpl(rootGameTree);
    }
    
    /**
	 * @param rootGameTree
	 * @return
	 */
    static private SgfColor firstMoveImpl(GameTree gameTree) {
		for (Node node : gameTree.getSequence()) {
			if (node.contains(SgfId.WHITE)) {
				return SgfColor.WHITE;
			}
			if (node.contains(SgfId.BLACK)) {
				return SgfColor.BLACK;
			} 
		}
		if (gameTree.getChildrenSize() == 0) {
			return null;
		}
		return firstMoveImpl(gameTree.getChild(0));
	}


	/**
     * 
     */
    protected BasicFinder() {
        super();
    }
}
