/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf.util;

import java.util.Collection;

import org.unitarou.sgf.type.SgfPoint;

/**
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class BasicFormatter {

	
	
	/**
	 * fobNpȂǂ{@link SgfPoint}̔z
	 * {[x,y][x,y]...}̌`ŃtH[}bgĕԂ܂B
	 * 
	 * @param points 
	 * @return points<code>null</code>̏ꍇ<code>null</code>Ԃ܂B
	 */
	static public String format(Collection<SgfPoint> points) {
		if (points == null) {
			return null;
		}
		StringBuilder builder = new StringBuilder();
		builder.append('{');
		for (SgfPoint point : points) {
			builder.append('[');
			builder.append(point.x()).append(',').append(point.y());
			builder.append(']');
		}
		if (!points.isEmpty()) {
			builder.append(points.iterator().next().size().toString());
		}
		builder.append('}');
		return builder.toString();
	}
	/**
	 * 
	 */
	protected BasicFormatter() {
		super();
	}
}
