/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf.util;

import java.util.IdentityHashMap;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.Sgfs;
import org.unitarou.util.ArgumentChecker;


/**
 * org.unitarou.sgf.ȉ̃pbP[Ẅ`FbNWbNłB
 * ꕔ̃WbN̓`FbÑRXg傫߁A
 * "org.unitarou.sgf.util.SgfArgumentChecker.INSPECT = DEBUG"ȊOł
 * `FbN܂B
 * 
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class SgfArgumentChecker {

	/** 
	 * ̃NX̃`FbNWbNs邩ǂ肷郍K[łB<br>
	 * L["org.unitarou.sgf.util.SgfArgumentChecker.INSPECT"ŁAOxDEBUG̏ꍇ̂݁A
	 * `FbNs܂B
	 */
	static private final Log logInspect_s_ 
			= LogFactory.getLog(SgfArgumentChecker.class.getName() + ".INSPECT"); //$NON-NLS-1$
	
	
	/**
	 * nodeparent̒ڂ̎qłȂꍇɗO𑗏o܂B<br>
	 * ̃`FbNWbN̓RXg傫
	 * ({@link org.unitarou.sgf.Sequence}{@link Node}ɔ)̂ŁA
	 * {@link Log#isDebugEnabled()}==trueȊOł͉܂B
	 * 
	 * @param node
	 * @param parent
	 * 
	 * @throws IllegalArgumentException nodeparent̒ڂ̎qłȂꍇB
	 * @throws org.unitarou.lang.NullArgumentException <code>null</code>̏ꍇ
	 */
	static public void throwIfNotAChild(Node node, GameTree parent) {
		if (!logInspect_s_.isDebugEnabled()) {
			return;
		}
		ArgumentChecker.throwIfNull(node, parent);
		for (Node n : parent.getSequence()) {
			if (n == node) {
				return;
			}
		}
		throw new IllegalArgumentException(node + " is not a child of " + parent); //$NON-NLS-1$
	}
	
	
	/**
	 * rootGameTreeŜ̐`FbNs܂B
	 * ̓Iɂ́F<br>
	 * 1. RootGameTree擪ɂ݂̂邩H<br>
	 * 2. eGameTree瓯RootGameTreeɓBł邩H
	 * 3. GameTreeċAĂȂH(CX^Xӏɑ݂Ȃ)<br>
	 * 4. NodeɏdiCX^Xӏɑ݂Ȃj<br>
	 * 
	 * ̃`FbNWbN̓RXg傫̂
	 * {@link Log#isDebugEnabled()}==trueȊOł͉܂B
	 * @param rootGameTree
	 */
	static public void throwIfInvalid(RootGameTree rootGameTree) {
		if (!logInspect_s_.isDebugEnabled()) {
			return;
		}
		ArgumentChecker.throwIfNull(rootGameTree);
		IdentityHashMap<GameTree, Object> gameTreeMap 
				= new IdentityHashMap<GameTree, Object>();
		
		IdentityHashMap<Node, Object> nodeMap 
				= new IdentityHashMap<Node, Object>();
		
		throwIfInvalidImpl(gameTreeMap, nodeMap, rootGameTree);
		logInspect_s_.debug("No problems occurred,"); //$NON-NLS-1$
	}


	/**
	 * {@link #throwIfInvalid(RootGameTree)}̎\bhłB
	 * 
	 * @param gameTreeMap
	 * @param nodeMap
	 * @param rootGameTree
	 */
	static private  void throwIfInvalidImpl(
			IdentityHashMap<GameTree, Object> gameTreeMap, 
			IdentityHashMap<Node, Object> nodeMap,
			GameTree gameTree) 
	{
		if (gameTreeMap.containsKey(gameTree)) {
			throw new IllegalArgumentException(gameTree + " show twice"); //$NON-NLS-1$
		}
		gameTreeMap.put(gameTree, new Object());
		
		GameTree root = Sgfs.getRoot(gameTree);
		if (root instanceof RootGameTree) {
			if (!gameTreeMap.containsKey(root)) {
				throw new IllegalArgumentException("Another RootGameTree is found. It is " + root); //$NON-NLS-1$
			}
			
		} else {
			throw new IllegalArgumentException(gameTree + "\'s root is not RootGameTree. It is " + root); //$NON-NLS-1$
		}
		
		for (Node node : gameTree.getSequence()) {
			if (nodeMap.containsKey(node)) {
				throw new IllegalArgumentException(node + " show twice"); //$NON-NLS-1$
			}
			nodeMap.put(node, new Object());
		}
		
		for (GameTree child : gameTree.getChildren()) {
			if (child instanceof RootGameTree) {
				throw new IllegalArgumentException(child + " has RootGameTree."); //$NON-NLS-1$
			}
			if (child.getParent() != gameTree) {
				throw new IllegalArgumentException(child + " doesn't indicate Parent."); //$NON-NLS-1$
			}
			throwIfInvalidImpl(gameTreeMap, nodeMap, child);
		}
	}
}
