/* 
 * Copyright 2004, 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.util.ArgumentChecker;


/**
 * {@link org.unitarou.sgf.type.SgfPoint}̏WƂĒ`܂B
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class SgfPointSet {

    /** Point̏WŁA^[{@link SgfPoint}]łB */
    private final Set<SgfPoint> pointSet_;

    /**
     * 
     */
    public SgfPointSet() {
        super();
        pointSet_ = new HashSet<SgfPoint>();
    }
    
    
    /**
     * point݂̏Wɒǉ܂B
     * ɒǉĂꍇ́AԂɕῶ܂B
     * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
     */
    public void add(SgfPoint point) {
        ArgumentChecker.throwIfNull(point);
        pointSet_.add(point);
    }
    
    /**
     * points̑Svf݂̏Wɒǉ܂B
     * ɒǉĂꍇ́AԂɕῶ܂B
     * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
     */
    public void add(SgfPoint[] points) {
        ArgumentChecker.throwIfNull((Object[])points);
        for (int i = 0; i < points.length; ++i) {
            pointSet_.add(points[i]);
        }
    }

    /**
     * point݂̏W폜܂B
     * ݂Ȃꍇ́AԂɕῶ܂B
     * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
     */
    public void remove(SgfPoint point) {
        ArgumentChecker.throwIfNull(point);
        pointSet_.remove(point);
    }

    /**
     * points̑Svf݂̏W폜܂B
     * ݂Ȃꍇ́AԂɕῶ܂B
     * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
     */
    public void remove(SgfPoint[] points) {
        ArgumentChecker.throwIfNull((Object[])points);
        for (int i = 0; i < points.length; ++i) {
            pointSet_.remove(points[i]);
        }
    }

    /**
     * point݂̏WɊ܂܂ĂƂtrueԂ܂B
     * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
     */
    public boolean contains(SgfPoint point) {
        ArgumentChecker.throwIfNull(point);
        return pointSet_.contains(point);
    }

    /**
     * W̏ꍇtrueԂ܂B
     */
    public boolean isEmpty() {
        return pointSet_.isEmpty();
    }

    
    /**
     * ݕێĂWNA[܂B
     */
    public void clear() {
        pointSet_.clear();
    }
    
    
    /**
     * ݕێĂPoint̏WׂĊ܂
     * ŏ̋`}XPʂŕԂ܂B
     */
    public SgfRectangle calcRedrawArea() {
        // x1,y1,x2,y2ƂĈĂ܂B
        SgfRectangle redrawArea = new SgfRectangle();
        for (Iterator ip = pointSet_.iterator(); ip.hasNext(); ) {
            redrawArea.intersect((SgfPoint)ip.next());
        }
        return redrawArea;
    }


    /**
     * ݂̏WɂāAKɋ`̈؂oĕԂ܂B<br>
     * {@link SgfPointType#PASS}͖܂B
     */
    public SgfRectangle[] getRegularRectangles() {
        List<SgfRectangle> list = new ArrayList<SgfRectangle>();
        Set<SgfPoint> workSet = new TreeSet<SgfPoint>(pointSet_);
        while (!workSet.isEmpty()) {
            SgfPoint element = workSet.iterator().next();
            if (element.condition().equals(SgfPointType.PASS)) {
            	workSet.remove(element);
            	continue;
            }
            SgfRectangle rectangle = findBestRectangle(workSet, element);
            list.add(rectangle);
            for (int x = rectangle.getStart().x(); x <= rectangle.getEnd().x(); ++x) {
                for (int y = rectangle.getStart().y(); y <= rectangle.getEnd().y(); ++y) {
                    workSet.remove(SgfPoint.create(element.size(), x, y));
                }
            }
        }
        return list.toArray(new SgfRectangle[list.size()]);
    }
    
    /**
     * start珇ɃT[`end܂őSĂɒl݂ő̋`Ԃ܂B
     */
    private SgfRectangle findBestRectangle(Set pointSet, SgfPoint start) {
        // ߂ɍsƗōől𒲂ׂ
        int endX = start.x();
        for (int x = start.x() + 1; x <= start.size().width(); ++x) {
            SgfPoint point = SgfPoint.create(start.size(), x, start.y());
            if (!pointSet.contains(point)) {
                break;
            }
            endX = x;
        }
        
        int endY = start.y();
        for (int y = start.y() + 1; y <= start.size().height(); ++y) {
            SgfPoint point = SgfPoint.create(start.size(), start.x(), y);
            if (!pointSet.contains(point)) {
                break;
            }
            endY = y;
        }
        
        // s̔zAg͖ʐ(Ps̋`̖ʐρAQs̋`̖ʐρc)
        int[] area = new int[endY - start.y() + 1];
        area[0] = endX - start.x() + 1;
        
        // Psł̍őAQsł̍őARsł̋`ɂłől𒲂ׂ
        for (int y = start.y() + 1; y <= endY; ++y) {
            int lastX = start.x();
            for (int x = start.x() + 1; x <= endX; ++x) {
                SgfPoint point = SgfPoint.create(start.size(), x, y);
                if (!pointSet.contains(point)) {
                    endX = lastX;
                    break;
                }
                lastX = x;
            }
            // `̖ʐς߂
            area[y - start.y()] = (y - start.y() + 1) * (endX - start.x() + 1);
        }
        
        // ʐύő̍sT
        int maxRow = 0;
        int maxArea = area[0];
        for (int i = 1; i < area.length; ++i) {
            if (maxArea < area[i]) {
                maxArea = area[i];
                maxRow = i;
            }
        }
        ++maxRow; // PIWɏC
        
        // ʐς񐔂o
        int maxCol = maxArea / maxRow;
        
        // sƗ񐔂`쐬B
        SgfRectangle ret = new SgfRectangle();
        ret.set(start, SgfPoint.create(start.size(), start.x() + maxCol - 1, start.y() + maxRow - 1));
        return ret;
    }
}
