/* 
 * Copyright 2004, 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */package org.unitarou.sgf.util;


import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.util.ArgumentChecker;

/**
 * Ղ̊eWɓĂ^\NXłB
 * @author UNITAROU &lt;boss@unitarou.org&gt;
 */
public enum SgfPointType {
	/** ΂ */ 		BLACK,
	/** ΂ */ 		WHITE,
	/** ΂Ȃ */ 		EMPTY,
	
	/** ֎~n_ */ 	FORBIDDEN,
	/** ΂dȂĂ*/	OVERLAP,
	
	/** Ղ̍[ */		TOP_LEFT,
	/** Ղ̏[ */			TOP,
	/** Ղ̉E[ */		TOP_RIGHT,
	/** Ղ̍[ */			LEFT,
	/** Ղ̉E[ */			RIGHT,
	/** Ղ̍[ */		BOTTOM_LEFT,
	/** Ղ̉[ */			BOTTOM,
	/** Ղ̉E[ */		BOTTOM_RIGHT,
	/** _ */			STAR,

	/** Ղ̒ */			IN,
    /** Ղ̊O */			OUT,
    
    /** 肪pX */		PASS,
    ;

    
	/**
	 * x,y Ղ̒[ǂ𔻒肵ÂꂩԂ܂F
	 * {@link #TOP_LEFT}
	 * {@link #TOP}
	 * {@link #TOP_RIGHT}
	 * {@link #LEFT}
	 * {@link #EMPTY}
	 * {@link #RIGHT}
	 * {@link #BOTTOM_LEFT}
	 * {@link #BOTTOM}
	 * {@link #BOTTOM_RIGHT}
	 */
	static public SgfPointType classify(SgfPoint point) {
		ArgumentChecker.throwIfNull(point);
	    int x = point.x();
	    int y = point.y();
	    SgfSize size = point.size();
		if (x == 1) {
		    return (y == 1) ? SgfPointType.TOP_LEFT :
		        	((y == size.height()) ? SgfPointType.BOTTOM_LEFT : SgfPointType.LEFT); 
			
		} else if (x == size.width()) {
		    return (y == 1) ? SgfPointType.TOP_RIGHT :
	        		((y == size.height()) ? SgfPointType.BOTTOM_RIGHT : SgfPointType.RIGHT); 
			
		}
	    return (y == 1) ? SgfPointType.TOP :
	    		((y == size.height()) ? SgfPointType.BOTTOM : SgfPointType.EMPTY); 
	}
	
}