/* 
 * Copyright 2004, 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf.util;

import org.unitarou.lang.Objects;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.type.SgfColor;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.util.ArgumentChecker;



/**
 * u΁v\NXłB<br>
 * ̓Iɂ́uFvƁuꏊvɉĉL̃Ame[Vێ܂F
 * <ol>
 * <li>ԍ({@link org.unitarou.sgf.SgfId#SET_MOVE_NUMBER}܂)</li>
 * <li>l</li>
 * </ol>
 * 
 * ̃NXImmutablełB
 */
public class Stone {

	/**
	 * nodeɒ{@link SgfId}ꍇɁA̒ll߂ĕԂ܂B
	 * ݂Ȃꍇ{@link #NULL_STONE}Ԃ܂B
	 * @param node
	 * @param sgfSize
	 * @return
	 * @throws org.unitarou.lang.NullArgumentException null̏ꍇB
	 */
	static public Stone create(Node node, SgfSize sgfSize) {
		ArgumentChecker.throwIfNull(node, sgfSize);

		for (SgfColor color : new SgfColor[]{SgfColor.WHITE, SgfColor.BLACK}) {
			Property p = node.getProperty(color.moveType());
			if (p == null) {
				continue;
			}
			return new Stone(
					color, 
					SgfPoint.parseMoveQuietly(sgfSize, p.getString()),
					null);
		}
		return NULL_STONE;
	}
	
	/**
	 * ̃NXnullIuWFNgłB
	 * {@link #isValid()}ŕKfalseԂ܂B
	 */
	static public final Stone NULL_STONE = new Stone();
	
	/**
	 * ̃NX̊i[vf0̔złB
	 */
	static public final Stone[] EMPTY_ARRAY = new Stone[0]; 

	/**
	 * ΂̐Fێ܂B
	 */
	private final SgfColor color_;

	/**
	 * łB 
	 */
	private final SgfPoint point_;

	/**
	 * ̔ԍłB(B,WꍇAMNm[hƂ)ɐݒ肳܂B
	 * ȊȌꍇɂnullԂ܂B
	 */
	private final Integer number_;
	
	/**
	 * ̈ɂԂێ܂B
	 */
	private final Double timeLapsed_;
	
	
	/**
	 * {@link #NULL_STONE}p̃RXgN^łB
	 * SĂGetter<code>null</code>ԂCX^XɂȂ܂B
	 */
	private Stone() {
	    super();
	    color_ = null;
	    point_ = null;
	    number_ = null;
	    timeLapsed_ = null;
	}
	
	/**
	 * 
	 * @param color
	 * @param point
	 * @param number
	 * @throws org.unitarou.lang.NullArgumentException colorpointnull̏ꍇB
	 */
	public Stone(SgfColor color, SgfPoint point, Integer number) {
	    this(color, point, number, null);
	}

	/**
	 * 
	 * @param color
	 * @param point
	 * @param number
	 * @throws org.unitarou.lang.NullArgumentException colorpointnull̏ꍇB
	 */
	public Stone(SgfColor color, SgfPoint point, Integer number, Double timeLapsed) {
	    super();
	    ArgumentChecker.throwIfNull(color, point);
	    color_ = color;
	    point_ = point;
	    number_ = number;
	    timeLapsed_ = timeLapsed;
	}

    
	/**
	 * 肪݂Ȃꍇ(pX͏܂)nullԂ܂B
	 */
    public SgfPoint getPoint() {
        return point_;
    }
    
	/**
	 * 肪݂ȂꍇnullԂ܂B
	 */
    public SgfColor getColor() {
        return color_;
    }

    /**
	 * ԍ݂ȂꍇnullԂ܂B
	 */
    public Integer getNumber() {
        return number_;
    }
    
    
    /**
     * ԂvZłȂꍇnullԂ܂B
     */
    public Double getTimeLapsed() {
    	return timeLapsed_;
    }
    
    /**
     * ݂̒肪݂ꍇtrueԂ܂B
     * {@link #getPoint()}!=null {@link #getColor()} != null̂Ƃ
     * trueԂ܂B
     */
    public boolean isValid() {
        return (point_ != null) && (color_ != null);
    }

	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
	    if (this == obj) {
			return true;
	    }
		if ( (obj == null) || (!obj.getClass().equals(this.getClass()))) {
			return false;

		} 
		Stone s = (Stone)obj;
		return Objects.equalsIncludeNull(color_, s.color_)
				&& Objects.equalsIncludeNull(point_, s.point_)
				&& Objects.equalsIncludeNull(number_, s.number_);
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		return Objects.hashCodeIncludeNull(color_)
				+ 3 * Objects.hashCodeIncludeNull(number_)
				+ 1033 * Objects.hashCodeIncludeNull(point_);
	}
    
    
}