/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf.util.filter;

import org.unitarou.sgf.Collection;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.Value;
import org.unitarou.util.Filter;
import org.unitarou.util.FilterException;
import org.unitarou.util.NestedFilter;

/**
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
abstract public class AbstractSgfFilter extends NestedFilter<Collection> {

	/**
	 * 
	 */
	public AbstractSgfFilter() {
		super();
	}

	/**
	 * @param parent null܂B
	 */
	public AbstractSgfFilter(Filter<Collection> parent) {
		super(parent);
	}

	/* (non-Javadoc)
	 * @see org.unitarou.util.NestedFilter#filter(T)
	 */
	@Override
	public Collection filter(Collection collection) throws FilterException {
		collection = super.filter(collection);
		collection = filterCollection(collection);
		Collection ret = new Collection();
		for (RootGameTree rgt : collection) {
			ret.addLast(filterRootGameTreeFrame(rgt));
		}
		return ret;
	}

	/**
	 * @param rgt
	 * @return
	 */
	private RootGameTree filterRootGameTreeFrame(RootGameTree rgt) {
		rgt = filterRootGameTree(rgt);
		RootGameTree ret = new RootGameTree(rgt);
		ret.getSequence().clear();
		for (Node node : rgt.getSequence()) {
			ret.getSequence().addLast(filterNodeFrame(node));
		}
		
		ret.clearGameTree();
		for (GameTree child : rgt.getChildren()) {
			ret.addGameTree(filterGameTreeFrame(child));
		}
		return ret;
	}
	
	/**
	 * @param rgt
	 */
	private GameTree filterGameTreeFrame(GameTree gameTree) {
		gameTree = filterGameTree(gameTree);
		GameTree ret = new GameTree(gameTree);
		ret.getSequence().clear();
		for (Node node : gameTree.getSequence()) {
			ret.getSequence().addLast(filterNodeFrame(node));
		}
		
		ret.clearGameTree();
		for (GameTree child : gameTree.getChildren()) {
			ret.addGameTree(filterGameTreeFrame(child));
		}
		
		return ret;
	}

	/**
	 * @param node
	 * @return
	 */
	private Node filterNodeFrame(Node node) {
		node = filterNode(node);
		Node ret = new Node(node);
		ret.clearProperty();
		for (Property property : node.getProperties()) {
			property = filterPropertyFrame(property);
			if (property.isValid()) {
				ret.addProperty(property);
			}
		}
		return ret;
	}


	/**
	 * @param property
	 * @return
	 */
	private Property filterPropertyFrame(Property property) {
		property = filterProperty(property);
		if (!property.isValid()) {
			return property;
		}
		Property ret = new Property(property);
		ret.clearValue();
		for (Value value : property.getValues()) {
			ret.addValue(filterValue(value, ret.sgfId()));
		}
		return ret;
	}


	/**
	 * {@link RootGameTree}ȉ̗vfɂĂ͏ȂłB
	 * @param collection
	 * @return
	 */
	protected Collection filterCollection(Collection collection) {
		return collection;
	}
	
	/**
	 * @param rgt
	 * @return
	 */
	protected RootGameTree filterRootGameTree(RootGameTree rgt) {
		return rgt;
	}
	
	/**
	 * @param rgt
	 * @return
	 */
	protected GameTree filterGameTree(GameTree gameTree) {
		return gameTree;
	}

	/**
	 * @param node
	 * @return
	 */
	protected Node filterNode(Node node) {
		return node;
	}

	/**
	 * @param property
	 * @return
	 */
	protected Property filterProperty(Property property) {
		return property;
	}
	
	/**
	 * @param value
	 * @return
	 */
	protected Value filterValue(Value value, SgfId sgfId) {
		return value;
	}
}
