/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf.util.filter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.Value;
import org.unitarou.sgf.ValueType;
import org.unitarou.sgf.type.Label;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.util.Filter;
import org.unitarou.util.FilterException;
import org.unitarou.util.NullFilter;

/**
 * SgfIuWFNg{@link org.unitarou.sgf.Collection}, 
 * {@link org.unitarou.sgf.GameTree}, {@link org.unitarou.sgf.Sequence},
 * {@link org.unitarou.sgf.Node}ɑ΂Ċ{IȃtB^OsWbNNXłB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class BasicFilter {

    //------------------ mirrorRotate p\bhEtB[hQ 
    /**
     * Wϊp̃tB^[WłB
     */
    static private final List<Filter<SgfPoint>> coordinateFilters_s_;
    static  {
	   List<Filter<SgfPoint>> list = new ArrayList<Filter<SgfPoint>>(8);
	   list.add(new NullFilter<SgfPoint>()); 
	   list.add(new Rotate90Filter()); 
	   list.add(new Rotate180Filter()); 
	   list.add(new Rotate270Filter());
	   list.add(new ReflectionFilter());
	   list.add(new Rotate90Filter(new ReflectionFilter()));
	   list.add(new Rotate180Filter(new ReflectionFilter()));
	   list.add(new Rotate270Filter(new ReflectionFilter()));
	   coordinateFilters_s_ = Collections.unmodifiableList(list);
   }
    
    /**
     * rootGameTreeɑ΂āA{@link ValueType}ɑ
     * SProperty̒lύXĉ]Å܂F
     * E{@link ValueType#MOVE}
     * E{@link ValueType#POINT}
     * E{@link ValueType#CPOINT}
     * ELBvpeB
     * @param type ]A̕B
     *              (0:ȂA1:90xE]A2:180x]A3:270xE]A
     *               4:aa-ZZɐΏ́A5:aa-ZZɐΏ́{90xE]A
     *               6:aa-ZZɐΏ́{180x]A7:aa-ZZɐΏ́{270xE])
     * @throws FilterException ϊɎsꍇ rootGameTree͓r܂ŏĂ܂B
     * @throws org.unitarou.lang.NullArgumentException rootGameTreenull̏ꍇ
     * @throws IllegalArgumentException type0菬7傫ꍇ
     */
    static public void mirrorRotate(RootGameTree rootGameTree, int type) 
    		throws FilterException 
    {
        ArgumentChecker.throwIfNull(rootGameTree);
        if ((type < 0) || (coordinateFilters_s_.size() <= type)) {
            throw new IllegalArgumentException("Bad type: " + type); //$NON-NLS-1$
        }
        Filter<SgfPoint> filter = coordinateFilters_s_.get(type);
        mirrorRotateImpl(rootGameTree, rootGameTree.getSize(), filter);
    }

    /**
     * @param rootGameTree
     * @param filter
     * @throws FilterException
     */
    private static void mirrorRotateImpl(
            GameTree gameTree, SgfSize size, Filter<SgfPoint> filter) 
    		throws FilterException
    {
    	for (Node node : gameTree.getSequence()) {
            for (Property property : node.getProperties()) {
                node.removeProperty(property.getId());
                node.addProperty(mirrorRotateImpl(property, size, filter));
            }
    	}
        
        for(int i = 0; i < gameTree.getChildrenSize(); ++i) {
            mirrorRotateImpl(gameTree.getChild(i), size, filter);
        }
    }
    
    static private Property mirrorRotateImpl(
            Property property, SgfSize size, Filter<SgfPoint> filter) 
    		throws FilterException 
    {
        ValueType type = property.sgfId().valueType();
        if (type.equals(ValueType.MOVE)
                || type.equals(ValueType.POINT) 
                || type.equals(ValueType.CPOINT)) 
        {
            String[] data = property.getStrings();
            SgfPoint[] sgfPoints = SgfPoint.parse(size, data);
            Property newProp = new Property();
            newProp.setId(property.getId());
            for (int k = 0; k < sgfPoints.length; ++k) {
                SgfPoint p = filter.filter(sgfPoints[k]);
                newProp.addValue(new Value(p.getString()));
            }
            // TODO Ó`FbN
            return newProp;
            
        } else if (property.sgfId().equals(SgfId.LABEL)) {
            Property newProp = new Property();
            newProp.setId(property.getId());
            String[] data = property.getStrings();
            for (int i = 0; i < data.length; ++i) {
                Label label = Label.parseQuietly(size, data[i]);
                if (label == null) {
                    continue;
                }
                label = new Label(filter.filter(label.getPoint()), label.getLabel());
                newProp.addValue(new Value(label.getString()));
            }
            // TODO Ó`FbN
            return newProp;
        }
        return property;
    }

    /**
     * 
     */
    protected BasicFilter() {
        super();
    }
}
