/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf.util.filter;

import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.util.SgfPointType;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.util.FilterException;
import org.unitarou.util.NestedFilter;

/**
 * xyւtB^[łBʓIy=xɐΏ̂ȍWԂ܂B
 * Ղ`ł͂ȂAϊ̍WՂ͂ݏoꍇA
 * {@link org.unitarou.util.FilterException}𑗏o܂B
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class ReflectionFilter extends NestedFilter<SgfPoint> {
    
    /**
     * <code>ReflectionFilter(null)</code>ƓłB
     */
    public ReflectionFilter() {
        this(null);
    }
    
    /**
     * vC}[RXgN^łB
     * @param parent
     */
    public ReflectionFilter(NestedFilter<SgfPoint> parent) {
        super(parent);
    }

    /* (non-Javadoc)
     * @see org.unitarou.sgf.util.filter.SgfPointFilter#filter(org.unitarou.sgf.type.SgfPoint)
     */
    @Override
	public SgfPoint filter(SgfPoint sgfPoint) throws FilterException {
        ArgumentChecker.throwIfNull(sgfPoint);
        sgfPoint = super.filter(sgfPoint);

        if (sgfPoint.condition().equals(SgfPointType.PASS)) {
            return sgfPoint;
        }
        // xyւ
        int x = sgfPoint.y();
        int y = sgfPoint.x();
        SgfSize size = sgfPoint.size();
        if ((x <= size.width()) && (y <= size.height())) {
            return SgfPoint.create(sgfPoint.size(), x, y);
        }
        throw new FilterException();
    }

}
