/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf.util.filter;

import org.unitarou.lang.Strings;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.Sgfs;
import org.unitarou.sgf.Value;
import org.unitarou.sgf.ValueType;
import org.unitarou.util.Filter;

/**
 * SGFŒ`ĂSoft line breakSč폜tB^[łB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class RemoveSoftLineBreakFilter extends AbstractSgfFilter {
	
	/**
	 * SGF`ĂSoft line break̔złB
	 */
	static private final String[] SOFT_LINE_BREAKS = {
		Sgfs.ESCAPE_SOFT_LINE_BREAK + "\r\n", //$NON-NLS-1$
		Sgfs.ESCAPE_SOFT_LINE_BREAK + "\n\r", //$NON-NLS-1$
		Sgfs.ESCAPE_SOFT_LINE_BREAK + "\r", //$NON-NLS-1$
		Sgfs.ESCAPE_SOFT_LINE_BREAK + "\n", //$NON-NLS-1$
	};

	/**
	 * 
	 */
	public RemoveSoftLineBreakFilter() {
		super();
	}

	/**
	 * @param parent
	 */
	public RemoveSoftLineBreakFilter(Filter<Collection> parent) {
		super(parent);
	}

	/* (non-Javadoc)
	 * @see org.unitarou.sgf.util.filter.AbstractSgfFilter#filterValue(org.unitarou.sgf.Value, org.unitarou.sgf.SgfId)
	 */
	@Override
	protected Value filterValue(Value value, SgfId sgfId) {
		value = super.filterValue(value, sgfId);
		if (sgfId.valueType().equals(ValueType.TEXT) || sgfId.valueType().equals(ValueType.SIMPLE_TEXT)) {
			String string = value.getString();
			for (String target : SOFT_LINE_BREAKS) {
				string = string.replace(target, Strings.EMPTY);
			}
			value = new Value(string, value.getOpenUtr());
		}
		return value;
	}

}
