/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf.util.filter;

import org.unitarou.lang.Strings;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Collection;
import org.unitarou.sgf.GameTree;
import org.unitarou.sgf.Node;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.RootGameTree;
import org.unitarou.sgf.SgfId;
import org.unitarou.sgf.Value;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.util.Filter;

/**
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class RemoveUtrFilter extends AbstractSgfFilter {
	/**
	 * UTȐ@肷enumłB
	 */
	public enum Option {
		/** svf[^̂܂܎cƂӖ܂ */
		HOLDING,
		
		/** ̂ݍ폜AR[h͎cƂӖ܂ */ 
		REMOVE_TEXT,
		
		/** svȃf[^Sč폜邱ƂӖ܂*/ 
		REMOVE_ALL;
		
		/* (non-Javadoc)
		 * @see java.lang.Object#toString()
		 */
		@Override
		public String toString() {
			return new MessageResource(this.getClass(), name()).get();
		}
	}

	private Option option_;
	/**
	 * 
	 */
	public RemoveUtrFilter() {
		this(null);
	}

	/**
	 * ftHgł{@link Option#REMOVE_ALL}ݒ肳Ă܂B
	 * 
	 * @param parent null܂B
	 */
	public RemoveUtrFilter(Filter<Collection> parent) {
		super(parent);
		option_ = Option.REMOVE_ALL;
	}
	
	public void setOption(Option type) {
		ArgumentChecker.throwIfNull(type);
		option_ = type;
	}
	
	public Option getOption() {
		return option_;
	}
	

	/* (non-Javadoc)
	 * @see org.unitarou.sgf.util.filter.AbstractSgfFilter#filterRootGameTree(org.unitarou.sgf.RootGameTree)
	 */
	@Override
	protected RootGameTree filterRootGameTree(RootGameTree rgt) {
		rgt.setOpenUtr(filter(rgt.getOpenUtr()));
		rgt.setCloseUtr(filter(rgt.getCloseUtr()));
		return rgt;
	}

	/* (non-Javadoc)
	 * @see org.unitarou.sgf.util.filter.AbstractSgfFilter#filterGameTree(org.unitarou.sgf.GameTree)
	 */
	@Override
	protected GameTree filterGameTree(GameTree gameTree) {
		gameTree.setOpenUtr(filter(gameTree.getOpenUtr()));
		gameTree.setCloseUtr(filter(gameTree.getCloseUtr()));
		return gameTree;
	}

	/* (non-Javadoc)
	 * @see org.unitarou.sgf.util.filter.AbstractSgfFilter#filterNode(org.unitarou.sgf.Node)
	 */
	@Override
	protected Node filterNode(Node node) {
		node.setOpenUtr(filter(node.getOpenUtr()));
		node.setCloseUtr(filter(node.getCloseUtr()));
		return node;
	}

	/* (non-Javadoc)
	 * @see org.unitarou.sgf.util.filter.AbstractSgfFilter#filterProperty(org.unitarou.sgf.Property)
	 */
	@Override
	protected Property filterProperty(Property property) {
		property.setOpenUtr(filter(property.getOpenUtr()));
		property.setCloseUtr(filter(property.getCloseUtr()));
		return property;
	}

	/* (non-Javadoc)
	 * @see org.unitarou.sgf.util.filter.AbstractSgfFilter#filterValue(org.unitarou.sgf.Value)
	 */
	@Override
	protected Value filterValue(Value value, SgfId sgfId) {
		return new Value(value.getString(), filter(value.getOpenUtr()));
	}
	
	/**
	 * {@link #option_}̒lɂďςtB^[łB
	 * 
	 * @param utr
	 * @return
	 */
	private String filter(String utr) {
		
		switch (option_) {
		case HOLDING:
			break;
			
		case REMOVE_TEXT:
			StringBuilder builder = new StringBuilder(utr.length());
			for (int i = 0; i < utr.length(); ++i) {
				char c = utr.charAt(i);
				if (Character.isISOControl(c)) {
					builder.append(c);
				}
			}
			utr = builder.toString();
			break;
			
		case REMOVE_ALL:
			utr = Strings.EMPTY;
			break;

		default:
			assert false;
		}
		
		return utr;
	}
}


