/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf.util.filter;

import java.util.HashSet;
import java.util.Set;

import org.unitarou.sgf.Collection;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.SgfId;
import org.unitarou.util.ArgumentChecker;
import org.unitarou.util.Filter;

/**
 * {@link #included_}Ɋ܂܂Ăꍇɂ݂̂̂̂ԂtB^[łB
 * ܂܂ĂȂꍇ{@link org.unitarou.sgf.Property#Property()}Ԃ܂B
 * 
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class SieveBySgfIdFilter extends AbstractSgfFilter {
	
	private final Set<SgfId> included_;

	/**
	 * 
	 */
	public SieveBySgfIdFilter() {
		this((Filter<Collection>)null);
	}


	/**
	 * 
	 */
	public SieveBySgfIdFilter(SgfId... sgfIds) {
		this(null, sgfIds);
	}
	


	/**
	 * @param parent
	 */
	public SieveBySgfIdFilter(Filter<Collection> parent) {
		this(parent, new SgfId[0]);
	}

	/**
	 * ̃NX̃vCRXgN^łB
	 * @param parent
	 */
	public SieveBySgfIdFilter(Filter<Collection> parent, SgfId... sgfIds) {
		super(parent);
		included_ = new HashSet<SgfId>();
		setSgfIds(sgfIds);
	}


	/**
	 * ӂ邢ʂSgfIdݒ肵܂B
	 * @param sgfIds
	 */
	final public void setSgfIds(SgfId... sgfIds) {
		included_.clear();
		for (SgfId sgfId : sgfIds) {
			included_.add(sgfId);
		}
	}


	/* (non-Javadoc)
	 * @see org.unitarou.sgf.util.filter.AbstractSgfFilter#filterProperty(org.unitarou.sgf.Property)
	 */
	@Override
	protected Property filterProperty(Property property) {
		ArgumentChecker.throwIfNull(property);
		if (included_.contains(property.sgfId())) {
			return property;
		}
		return new Property();
	}
}
