/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf.util.provider.crdlp;

import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.util.Provider;
import org.unitarou.yukinoshita.context.ProviderContextValue;

/**
 * W\邽߂̃xvoC_[łB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public interface CoordinatesLabelProvider extends Provider {
    
    /**
     * {@link #getMoveLabel(SgfPoint)}Œ肪pX̏ꍇ
     * \ׂxłB
     */
    MessageResource LB_PASS = new MessageResource(CoordinatesLabelProvider.class, "lbPass"); //$NON-NLS-1$
    
    /**
     * ReLXg̃L[ƃftHgvoC_[łB
     * ftHg̃voC_[{@link InternetStyleProvider}łB
     */
    ProviderContextValue<CoordinatesLabelProvider> CONTEXT 
    		= new ProviderContextValue<CoordinatesLabelProvider>(
    				CoordinatesLabelProvider.class, 
    				new InternetStyleProvider());
    
    /**
     * XW̒lԂ܂B
     * TODO pX̏ꍇǂ邩߂ĂȂc
     * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
     */
    String getXLabel(SgfPoint sgfPoint);
    
    /**
     * YW̒lԂ܂B
     * TODO pX̏ꍇǂ邩߂ĂȂc
     * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
     */
    String getYLabel(SgfPoint sgfPoint);
    
    /**
     * X,Y̗WsŕԂ܂B
     * pX̏ꍇ̎|̕Ԃ܂B 
     * @throws org.unitarou.lang.NullArgumentException null̏ꍇ
     */
    String getMoveLabel(SgfPoint sgfPoint);
}
