/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf.util.provider.crdlp;

import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.util.SgfPointType;
import org.unitarou.util.ArgumentChecker;

/**
 * ʓIȃAvP[V̗pĂWnłB
 * ՂیƂ݂ȂAY𐔒lAXAt@xbgŕ\܂B
 * At@xbg͊ŁeIf𖳎Ă܂B
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class InternetStyleProvider implements CoordinatesLabelProvider {
    /**uC^[lbgWv*/
    static private final MessageResource LB_DISPLAY_NAME
    		= new MessageResource(InternetStyleProvider.class, "lbDisplayName"); //$NON-NLS-1$
    

    static private final String[] xLabels_s_;
    static {
        xLabels_s_ = new String[SgfSize.MAX_LENGTH];
        int index = 0;
        for (char i = 0; i < 26 ; ++i, ++index) {
            if (i == 8) {
                ++i;
            }
            xLabels_s_[index] = String.valueOf((char)('A' + i));
        }

        for (char i = 26; i < 52 ; ++i, ++index) {
            if (i == 34) {
                ++i;
            }
            xLabels_s_[index] = String.valueOf((char)('a' + i - 26));
        }
        xLabels_s_[50] = String.valueOf('\u03b1');
        xLabels_s_[51] = String.valueOf('\u03b2');
    }

    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.view.CoordinateLabelProvider#stringX(org.unitarou.sgf.type.SgfPoint)
     */
    public String getXLabel(SgfPoint sgfPoint) {
        ArgumentChecker.throwIfNull(sgfPoint);
        return xLabels_s_[sgfPoint.x() - 1];
    }

    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.view.CoordinateLabelProvider#stringY(org.unitarou.sgf.type.SgfPoint)
     */
    public String getYLabel(SgfPoint sgfPoint) {
        ArgumentChecker.throwIfNull(sgfPoint);
        return String.valueOf(sgfPoint.size().height() - sgfPoint.y() + 1);
    }

    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.view.CoordinatesLabelProvider#stringMove(org.unitarou.sgf.type.SgfPoint)
     */
    public String getMoveLabel(SgfPoint sgfPoint) {
        ArgumentChecker.throwIfNull(sgfPoint);
        if (sgfPoint.condition().equals(SgfPointType.PASS)) {
            return CoordinatesLabelProvider.LB_PASS.get();
        }
        return getXLabel(sgfPoint) + getYLabel(sgfPoint); //$NON-NLS-1$
    }

    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.view.clp.CoordinatesLabelProvider#getDisplayName()
     */
    public String displayName() {
        return LB_DISPLAY_NAME.get();
    }

}
