/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf.util.provider.crdlp;

import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.type.SgfSize;
import org.unitarou.sgf.util.SgfPointType;
import org.unitarou.util.ArgumentChecker;

/**
 * ʓIȓ{̗̊pĂW`łB
 * ՂlیƂ݂ȂāAYŌĂ܂B
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class JapaneseStyleProvider implements CoordinatesLabelProvider {
    /**u{Wv*/
    static private final MessageResource LB_DISPLAY_NAME
    		= new MessageResource(JapaneseStyleProvider.class, "lbDisplayName"); //$NON-NLS-1$

    static private final char[] KANSUJI
    	= new char[]{'', '', 'O', 'l', '', 'Z', '', '', ''}; 
    static private final char[] KANSUJI_10
    	= new char[]{'\', '', 'O', 'l', '', 'Z', '', '', ''}; 
    	
    
    static private final String[] KANSUJI_LABEL;
    static {
        KANSUJI_LABEL = new String[SgfSize.MAX_LENGTH];
        StringBuilder sb = new StringBuilder(3);
        for (int i = 1; i <= SgfSize.MAX_LENGTH; ++i) {
            int posTen = i / 10;
            int posOne = i % 10;

            if ((posTen != 0) && (i != 10)) {
                sb.append(KANSUJI_10[posTen - 1]);
            }
            if (posOne == 0) {
                sb.append(KANSUJI_10[0]);
            } else {
                sb.append(KANSUJI[posOne - 1]);
            }
            
            KANSUJI_LABEL[i - 1] = sb.toString();
            sb.delete(0, sb.length());
        }
    }
    
    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.view.CoordinateLabelProvider#stringX(org.unitarou.sgf.type.SgfPoint)
     */
    public String getXLabel(SgfPoint sgfPoint) {
        ArgumentChecker.throwIfNull(sgfPoint);
        return String.valueOf(sgfPoint.x());
    }

    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.view.CoordinateLabelProvider#stringY(org.unitarou.sgf.type.SgfPoint)
     */
    public String getYLabel(SgfPoint sgfPoint) {
        ArgumentChecker.throwIfNull(sgfPoint);
        return KANSUJI_LABEL[sgfPoint.y() - 1];
    }

    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.view.CoordinatesLabelProvider#stringMove(org.unitarou.sgf.type.SgfPoint)
     */
    public String getMoveLabel(SgfPoint sgfPoint) {
        ArgumentChecker.throwIfNull(sgfPoint);
        if (sgfPoint.condition().equals(SgfPointType.PASS)) {
            return CoordinatesLabelProvider.LB_PASS.get();
        }
        return getXLabel(sgfPoint) + "" + getYLabel(sgfPoint); //$NON-NLS-1$
    }

    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.view.clp.CoordinatesLabelProvider#getDisplayName()
     */
    public String displayName() {
        return LB_DISPLAY_NAME.get();
    }

}
