/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf.util.provider.crdlp;

import org.unitarou.lang.Strings;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.type.SgfPoint;

/**
 * {@link #getXLabel(SgfPoint)}{@link #getYLabel(SgfPoint)}A{
 * @link #getMoveLabel(SgfPoint)}
 * W\Ȃ(󕶎Ԃ)voC_[łB
 * 
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class NoCoordinatesProvider implements CoordinatesLabelProvider {
    /**u\Ȃv*/
    static private final MessageResource LB_DISPLAY_NAME
    		= new MessageResource(NoCoordinatesProvider.class, "lbDisplayName"); //$NON-NLS-1$

    /**
     * 
     */
    public NoCoordinatesProvider() {
        super();
    }

    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.view.clp.CoordinatesLabelProvider#stringX(org.unitarou.sgf.type.SgfPoint)
     */
    public String getXLabel(SgfPoint sgfPoint) {
        return Strings.EMPTY;
    }

    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.view.clp.CoordinatesLabelProvider#stringY(org.unitarou.sgf.type.SgfPoint)
     */
    public String getYLabel(SgfPoint sgfPoint) {
        return Strings.EMPTY;
    }

    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.view.clp.CoordinatesLabelProvider#stringMove(org.unitarou.sgf.type.SgfPoint)
     */
    public String getMoveLabel(SgfPoint sgfPoint) {
        return Strings.EMPTY;
    }

    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.view.clp.CoordinatesLabelProvider#getDisplayName()
     */
    public String displayName() {
        return LB_DISPLAY_NAME.get();
    }
}
