/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf.util.provider.crdlp;

import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.util.SgfPointType;
import org.unitarou.util.ArgumentChecker;

/**
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class NumericStyleProvider implements CoordinatesLabelProvider {

    /**ul`(x,y)v*/
    static private final MessageResource LB_DISPLAY_NAME
    		= new MessageResource(NumericStyleProvider.class, "lbDisplayName"); //$NON-NLS-1$

    /**
	 * 
	 */
	public NumericStyleProvider() {
		super();
	}

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.provider.crdlp.CoordinatesLabelProvider#getXLabel(org.unitarou.sgf.type.SgfPoint)
	 */
	public String getXLabel(SgfPoint sgfPoint) {
		ArgumentChecker.throwIfNull(sgfPoint);
		return String.valueOf(sgfPoint.x());
	}

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.provider.crdlp.CoordinatesLabelProvider#getYLabel(org.unitarou.sgf.type.SgfPoint)
	 */
	public String getYLabel(SgfPoint sgfPoint) {
		ArgumentChecker.throwIfNull(sgfPoint);
		return String.valueOf(sgfPoint.y());
	}

	/* (non-Javadoc)
	 * @see org.unitarou.yukinoshita.view.provider.crdlp.CoordinatesLabelProvider#getMoveLabel(org.unitarou.sgf.type.SgfPoint)
	 */
	public String getMoveLabel(SgfPoint sgfPoint) {
        ArgumentChecker.throwIfNull(sgfPoint);
        if (sgfPoint.condition().equals(SgfPointType.PASS)) {
            return CoordinatesLabelProvider.LB_PASS.get();
        }
        return '(' + getXLabel(sgfPoint) + ',' + getYLabel(sgfPoint) + ')'; 
	}

	/* (non-Javadoc)
	 * @see org.unitarou.lang.NameDisplayable#displayName()
	 */
	public String displayName() {
		return LB_DISPLAY_NAME.get();
	}

}
