/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf.util.provider.crdlp;

import org.unitarou.lang.Strings;
import org.unitarou.ml.MessageResource;
import org.unitarou.sgf.Sgfs;
import org.unitarou.sgf.type.SgfPoint;
import org.unitarou.sgf.util.SgfPointType;
import org.unitarou.util.ArgumentChecker;

/**
 * SgftH[}bgł̍Ŵ܂܂Ԃ܂B
 * @author unitarou &lt;boss@unitarou.org&gt;
 */
public class SgfStyleProvider implements CoordinatesLabelProvider {
    /**uSGF`v*/
    static private final MessageResource LB_DISPLAY_NAME
    		= new MessageResource(SgfStyleProvider.class, "lbDisplayName"); //$NON-NLS-1$

    /**
     * 
     */
    public SgfStyleProvider() {
        super();
    }

    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.view.clp.CoordinatesLabelProvider#stringX(org.unitarou.sgf.type.SgfPoint)
     */
    public String getXLabel(SgfPoint sgfPoint) {
        ArgumentChecker.throwIfNull(sgfPoint);
        if (SgfPointType.PASS.equals(sgfPoint.condition())) {
            return Strings.EMPTY;
        }
        return String.valueOf(Sgfs.toSgf(sgfPoint.x()));
    }

    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.view.clp.CoordinatesLabelProvider#stringY(org.unitarou.sgf.type.SgfPoint)
     */
    public String getYLabel(SgfPoint sgfPoint) {
        ArgumentChecker.throwIfNull(sgfPoint);
        if (SgfPointType.PASS.equals(sgfPoint.condition())) {
            return Strings.EMPTY;
        }
        return String.valueOf(Sgfs.toSgf(sgfPoint.y()));
    }

    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.view.clp.CoordinatesLabelProvider#stringMove(org.unitarou.sgf.type.SgfPoint)
     */
    public String getMoveLabel(SgfPoint sgfPoint) {
        ArgumentChecker.throwIfNull(sgfPoint);
        return sgfPoint.getString();
    }

    /* (non-Javadoc)
     * @see org.unitarou.yukinoshita.view.clp.CoordinatesLabelProvider#getDisplayName()
     */
    public String displayName() {
        return LB_DISPLAY_NAME.get();
    }
}
