/*  
 * Copyright 2005 unitarou <boss@unitarou.org>. 
 * All rights reserved.
 * 
 * This program and the accompanying materials are made available under the terms of 
 * the Common Public License v1.0 which accompanies this distribution, 
 * and is available at http://opensource.org/licenses/cpl.php
 * 
 * Contributors:
 *     unitarou - initial API and implementation
 */
package org.unitarou.sgf.util.provider.plp;

import java.util.HashSet;
import java.util.Set;

import org.unitarou.ml.MessageResource;
import org.unitarou.ml.Messages;
import org.unitarou.sgf.Property;
import org.unitarou.sgf.type.GameType;
import org.unitarou.sgf.util.provider.crdlp.CoordinatesLabelProvider;
import org.unitarou.util.ArgumentChecker;

/**
 * WIPropertyStringvoC_[łB<br>
 * <p>
 * {@link org.unitarou.sgf.ValueType#COLOR}, {@link org.unitarou.sgf.ValueType#DOUBLE}ł
 * gBasicPropertyLabelProvider.h+ GameTypeID + "." + SGFID + "." + SGF̒lȂL[
 * messages.properties猟ĕԂ܂BStringꍇ͏drăJ}؂ŕׂ܂B<br>
 * ȊÕ^CvɂĂ
 * gBasicPropertyLabelProvider.h+ GameTypeID + "." + SGFIDȂL[
 * messages.properties猟ĕԂ܂B<br>
 * </p>
 * 
 * <p>̌ʑ݂ȂꍇAȊÔ̂ɂĂ
 * {@link org.unitarou.sgf.SgfId#displayName()}̂܂ܕԂ܂B</p>
 * 
 * @author unitarou &lt;boss@unitarou.org&gt; 
 */
public class BasicPropertyLabelProvider implements PropertyLabelProvider {
	static private final Messages messages_s_ 
			= Messages.createByPackage(BasicPropertyLabelProvider.class);
	
	/**
	 * uWv
	 */
	static private final MessageResource LB_NAME
			= new MessageResource(BasicPropertyLabelProvider.class, "lbName"); //$NON-NLS-1$

	private CoordinatesLabelProvider clProvider_;
	/**
	 * 
	 */
	public BasicPropertyLabelProvider() {
		super();
		clProvider_ = CoordinatesLabelProvider.CONTEXT.defaultProvider();
	}
	/* (non-Javadoc)
	 * @see org.unitarou.lang.NameDisplayable#displayName()
	 */
	public String displayName() {
		return LB_NAME.get();
	}

	/* (non-Javadoc)
	 * @see org.unitarou.sgf.util.provider.plp.PropertyLabelProvider#setCoordinatesLabelProvider(org.unitarou.sgf.util.provider.crdlp.CoordinatesLabelProvider)
	 */
	public void setCoordinatesLabelProvider(CoordinatesLabelProvider provider) {
		ArgumentChecker.throwIfNull(provider);
		clProvider_ = provider;
	}

	/* (non-Javadoc)
	 * @see org.unitarou.sgf.util.provider.plp.PropertyLabelProvider#getCoordinatesLabelProvider()
	 */
	public CoordinatesLabelProvider getCoordinatesLabelProvider() {
		return clProvider_;
	}

	/* (non-Javadoc)
	 * @see org.unitarou.sgf.util.provider.plp.PropertyLabelProvider#getLabel(org.unitarou.sgf.type.GameType, org.unitarou.sgf.Property)
	 */
	public String getLabel(GameType gameType, Property property) {
		ArgumentChecker.throwIfNull(gameType, property);
		switch (property.sgfId().valueType()) {
		case DOUBLE:
		case COLOR:
			return getLabelWithValue(gameType, property);
			
		default:
			return getLabelWithIdOnly(gameType, property);
		}
	}

	/**
	 * @param property
	 * @return
	 */
	private String getLabelWithValue(GameType gameType, Property property) {
		String keyPrefix = Messages.createKey(
				BasicPropertyLabelProvider.class,
				gameType.getString() + '.'  + property.sgfId().id() + '.');
		
		Set<String> labels = new HashSet<String>();
		for (String string : property.getStrings()) {
			String key = keyPrefix + string;
			if (messages_s_.contains(key)) {
				labels.add(messages_s_.get(key));
			} else {
				labels.add(property.sgfId().displayName());
			}
		}
		StringBuilder builder = new StringBuilder();
		for (String label : labels) {
			builder.append(label).append(", "); //$NON-NLS-1$
		}
		if (!labels.isEmpty()) {
			builder.delete(builder.length() - 2, builder.length());
		}
		return builder.toString();
	}

	/**
	 * @param property
	 * @return
	 */
	private String getLabelWithIdOnly(GameType gameType, Property property) {
		String key = Messages.createKey(
				BasicPropertyLabelProvider.class,
				gameType.getString() + '.' + property.sgfId().id());
		if (messages_s_.contains(key)) {
			return messages_s_.get(key);
		}
		return property.sgfId().displayName();
	}
}
